<?php

/*******************************************************************************

    Author ....... Jonathan S. Earle
    Contact ...... plugins@kronos.honk.org
    Home Site .... http://kronos.honk.org/~earlej/
    Program ...... Canadian Weather

*******************************************************************************/

// Copied from the plugins.txt. Ensure this file is not called if 
// plugin is inactive.
/* Doesn't work!
global $plugins;
if ( !in_array('weather', $plugins) ) {
    die("Plugin not enabled in SquirrelMail configuration.");
}
*/

// Ensure the proper SM environment is setup. Copied from
// http://www.squirrelmail.org/docs/devel/devel.html#toc4.8
if (file_exists('../../include/init.php'))
   include_once('../../include/init.php');
else if (file_exists('../../include/validate.php'))
{
   define('SM_PATH', '../../');
   include_once(SM_PATH . 'include/validate.php');
}
else
{
   chdir('..');
   define('SM_PATH', '../');
   include_once(SM_PATH . 'src/validate.php');
}

global $color;
displayPageHeader($color, 'None');

// If we're using Javascript, then do the nice code lookups for the user.
// If not, then the user will have to parse the code from EC and paste it
// into a text edit box.
global $javascript_on;

$weather_lang = getPref($data_dir, $username, 'weather_lang');
$weather_position = getPref($data_dir, $username, 'weather_position');
$weather_province = getPref($data_dir, $username, 'weather_province');
$weather_region = getPref($data_dir, $username, 'weather_region');
$weather_unit = getPref($data_dir, $username, 'weather_unit');

$sel = '';

//
// Must choose Language, then province, then region.
//

echo '<form name="Form1" action="' . sqm_baseuri() . 'src/options.php" method="post">' . "\n" .
     html_tag('table', '', '', '', 'width="100%" cellpadding="5" cellspacing="0" border="0"') .
     "\n";
?>

<tr><td align="center" valign="middle" colspan="2" nowrap><b>
Weather Options / Survivez  aux options
</b></td></tr>

<!-- Screen position -->

<tr>
<td align=right>Position:</td>
<td>
<select name="weather_position_in">

<?php
    if ($weather_position == 'above')
        $sel = ' selected';

    print "<option value=above".$sel.">Above folder list\n";

    $sel = '';

    if ($weather_position == 'below' || $weather_position == '')
        $sel = ' selected';

    print "<option value=below".$sel.">Below folder list\n";

    $sel = '';
?>

</select>
</td>
</tr>

<!-- Language -->

<tr>
<td align=right>Language:<br>Langue:</td>
<td>
<select name="weather_lang_in" onchange="show_province_list(this)">

<?php
    // Default language is english if nothing else is set.
    if (!$weather_lang or ($weather_lang != "e" and $weather_lang != "f"))
    {
        $weather_lang = "e";
    }

    if ($weather_lang == 'e')
        $sel = ' selected';

    print "<option value=e".$sel.">English\n";

    $sel = '';

    if ($weather_lang == 'f')
        $sel = ' selected';

    print "<option value=f".$sel.">fran&ccedil;ais\n";
?>

</select>
</td>
</tr>

<?php
    if ($javascript_on)
        print "
<!-- Province -->

<tr>
<td align=right>Province:</td>
<td><select name=\"weather_province_in\" onchange=\"show_region_list(this)\">
</select></td>
</tr>
";
?>

<!-- Region -->

<tr>
<td align=right>Region:<br>Rgion:</td>
<td>
<?php
    if ($javascript_on)
        print "<select name=\"weather_region_in\"></select>";
    else
        print "<input name=\"weather_region_text_in\" size=6 maxlength=6" .
              " value=\"" . $weather_region . "\">*";
?>
</td>
</tr>

<!-- Unit of Measurement -->

<tr>
<td align=right>Measurement Units:<br>Units De Mesure:</td>
<td>
<select name="weather_unit_in">

<?php
    // Default unit is metric if nothing else is set.
    if (!$weather_unit or ($weather_unit != "m" and $weather_unit != "i"))
    {
        $weather_unit = "m";
    }

    if ($weather_unit == 'm')
        $sel = ' selected';

    print "<option value=m".$sel.">Metric\n";

    $sel = '';

    if ($weather_unit == 'i')
        $sel = ' selected';

    print "<option value=i".$sel.">Imperial\n";
?>

</select>
</td>
</tr>

<script type="text/javascript">
<!--
// Base URI for xmlhttprequest.
<?php
echo "var base_uri = " . sqm_baseuri() . "\n";
echo "var lang = '" . $weather_lang . "'\n";
echo "var sel_prov = '" . $weather_province . "'\n";
echo "var sel_region = '" . $weather_region . "'\n";
?>
// Base DOM layer for reduced typing in other Javascript code.
var base=document.Form1;
populate_boxes();
//-->
</script>

<tr><td COLSPAN="2">&nbsp;</td></tr>

<tr><td COLSPAN="2" align="middle"><b>Leave the Region setting blank to disable
the Canadian Weather plugin.</b></td></tr>
<tr><td COLSPAN="2" align="middle"><b>Laissez la rgion plaant blanche pour
neutraliser le Canadien Survivent   plugin.

<tr><td COLSPAN="2">&nbsp;</td></tr>

<?php
echo html_tag( 'tr', "\n" .
     html_tag( 'td', '&nbsp;' ) .
     html_tag( 'td',
               '<input type="hidden" name="optmode" value="submit" />' .
               '<input type="hidden" name="optpage" value="weather" />' .
               '<input type="submit" value="' . _("Submit / Soumettez") . 
                    '" name="submit_weather" />',
               'left' )
             ) . "\n";
?>

<?php
    if (!$javascript_on)
    {
        if ($weather_lang == "e")
            print "
<tr><td COLSPAN=\"2\" align=\"middle\">* See <a href=\"cw_code_help.png\">this
image</a> for what you need to extract from 
<a href=\"http://weatheroffice.ec.gc.ca/canada_e.html\" target=\"_new\">
Environment Canada</a> and insert here.</td></tr>
";
        else
            print "
<tr><td COLSPAN=\"2\" align=\"middle\">* Voir la 
<a href=\"cw_code_help.png\">cette image</a> pour ce que vous devez extraire 
partir de <a href=\"http://weatheroffice.ec.gc.ca/canada_f.html\" target=
\"_new\">l'environnement Canada</a> et insrer ici.</td></tr>
";
    }
?>

</table></form></body></html>
