<?php

/**
  * SquirrelMail Calendar Plugin File Backend
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



/** 
  * Fixes arrays
  *
  * Just removes empty entries and trims all others in an array
  *
  * @param array The array to fix (keys are ignored) (this array
  *              is passed by reference and is changed in place)
  *
  */
function cal_file_back_fix_array(&$arr)
{
   $newArr = array();
   foreach ($arr as $val)
      if (!empty($val))
         $newArr[] = trim($val);
   $arr = $newArr;
}



/**
  * Deletes a directory and all of its contents
  *
  * @param string $dirpath The path to the directory being removed
  *
  */
function cal_file_rmdir($dirpath)
{

   global $color;

   if ($DIR = @opendir($dirpath))
   {

      while (($file = readdir($DIR)) !== false)
      {

         if (($file == '.') || ($file == '..'))
            continue;

         if (is_dir($dirpath . '/' . $file))
            cal_file_rmdir($dirpath . '/' . $file);

         else
            if (!unlink($dirpath . '/' . $file))
            {
               plain_error_message('ERROR IN CALENDAR FILE BACKEND (cal_file_rmdir): cannot delete event file ' . $dirpath . '/' . $file, $color);
               exit;
            }

      }

      closedir($DIR);

      if (!rmdir($dirpath))
      {
         plain_error_message('ERROR IN CALENDAR FILE BACKEND (cal_file_rmdir): cannot delete event directory ' . $dirpath, $color);
         exit;
      }

   }
   else
   {
      plain_error_message('ERROR IN CALENDAR FILE BACKEND (cal_file_rmdir): cannot open event directory ' . $dirpath, $color);
      exit;
   }

}



?>
