<?php

/**
  * SquirrelMail Bypass Trash Plugin
  * Copyright (c) 2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage bypass_trash
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_bypass_trash()
{

   global $squirrelmail_plugin_hooks;


   // SM 1.4.x - places text and widgets on the folder page
   //
   $squirrelmail_plugin_hooks['folders_bottom']['bypass_trash']
      = 'bypass_trash_show_options';


   // SM 1.5.x - places text and widgets on the folder page
   //
   $squirrelmail_plugin_hooks['template_construct_folder_manip.tpl']['bypass_trash']
      = 'bypass_trash_show_options';


   // add link to action options below message headers
   //
   $squirrelmail_plugin_hooks['read_body_header_right']['bypass_trash']
      = 'bypass_trash_show_link';


   // SM 1.4.x - show bypass trash controls on mailbox list page
   //
   $squirrelmail_plugin_hooks['mailbox_display_buttons']['bypass_trash']
      = 'bypass_trash_show_controls';


   // SM 1.5.x - show bypass trash controls on mailbox list page
   //
   $squirrelmail_plugin_hooks['message_list_controls']['bypass_trash']
      = 'bypass_trash_show_controls';


   // SM 1.4.x - perform any needed actions
   //
   $squirrelmail_plugin_hooks['move_before_move']['bypass_trash']
       = 'bypass_trash_handle_button_click';


   // SM 1.5.x - perform any needed actions
   //
   $squirrelmail_plugin_hooks['mailbox_display_button_action']['bypass_trash']
       = 'bypass_trash_handle_button_click';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['bypass_trash']
      = 'bypass_trash_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function bypass_trash_info()
{

   return array(
                 'english_name' => 'Bypass Trash',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.11',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'required_plugins' => array(),
                 'summary' => 'Provides a means to allow users to quickly purge one or more messages without moving them to the trash first.',
                 'details' => 'This plugin provides configurable means to allow users to quickly purge one or more messages without moving them to the trash first.  A button (typically labeled "Wipe") can be shown on the message list screen for any folder (configurable by the administrator and/or the users), as can a "Wipe" link on the message view screen.  For SquirrelMail versions 1.4.x, a "bypass trash" checkbox can also be displayed, which modifies the "Delete" button as such (this is natively supported in versions 1.5.x).<br /><br />If the administrator allows user configuration of where these items are displayed, the user can navigate to the "Folders" link from the main SquirrelMail navigation to configure this plugin as needed.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function bypass_trash_version()
{
   $info = bypass_trash_info();
   return $info['version'];
}



/**
  * Places text and widgets on the folder page
  *
  */
function bypass_trash_show_options()
{
   include_once(SM_PATH . 'plugins/bypass_trash/options.php');
   return bypass_trash_show_options_do();
}



/**
  * Add link to action options below message headers
  *
  */
function bypass_trash_show_link(&$links)
{
   include_once(SM_PATH . 'plugins/bypass_trash/functions.php');
   bypass_trash_show_link_do($links);
}



/**
  * Show bypass trash controls on mailbox list page
  *
  */
function bypass_trash_show_controls(&$args)
{
  include_once(SM_PATH . 'plugins/bypass_trash/functions.php');
  bypass_trash_show_controls_do($args);
}



/**
  * Perform any needed actions when clicked from message list page
  *
  */
function bypass_trash_handle_button_click(&$args) 
{
  include_once(SM_PATH . 'plugins/bypass_trash/functions.php');
  return bypass_trash_handle_button_click_do($args);
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function bypass_trash_check_configuration()
{
   include_once(SM_PATH . 'plugins/bypass_trash/functions.php');
   return bypass_trash_check_configuration_do();
}



/**
  * Force the getpot script to pick up these translations
  * (which are in the config file in non-translated form)
  *
  * @ignore
  *
  */
function bt_no_op()
{
   $ignore = _("Wipe");
   $ignore = _("Purge");
   $ignore = _("Skip Trash");
   $ignore = _("Bypass Trash");
   $ignore = _("Permanent Delete");
   $ignore = _("Permanently remove the selected message(s)");
   $ignore = _("Purge the selected message(s)");
   $ignore = _("Delete the selected message(s), bypassing the trash");
   $ignore = _("Delete the selected message(s), skipping the trash");
   $ignore = _("When enabled, the Delete button will permanently remove the selected message(s)");
   $ignore = _("When enabled, the Delete button will permanently remove the selected message(s), skipping the trash");
   $ignore = _("When enabled, the Delete button will permanently remove the selected message(s), bypassing the trash");
   $ignore = _("When enabled, the Delete button will purge the selected message(s)");
   $ignore = _("When enabled, the Delete button will purge the selected message(s), skipping the trash");
   $ignore = _("When enabled, the Delete button will purge the selected message(s), bypassing the trash");
   $ignore = _("Wipe checkboxes on the message list page make the Delete button remove selected messages permanently.");
   $ignore = _("Purge checkboxes on the message list page make the Delete button remove selected messages permanently.");
   $ignore = _("Skip Trash checkboxes on the message list page make the Delete button remove selected messages permanently.");
   $ignore = _("Bypass Trash checkboxes on the message list page make the Delete button remove selected messages permanently.");
   $ignore = _("Permanent Delete checkboxes on the message list page make the Delete button remove selected messages permanently.");
   $ignore = _("Wipe buttons on the message list page remove the selected messages from the folder permanently.");
   $ignore = _("Purge buttons on the message list page remove the selected messages from the folder permanently.");
   $ignore = _("Skip Trash buttons on the message list page remove the selected messages from the folder permanently.");
   $ignore = _("Bypass Trash buttons on the message list page remove the selected messages from the folder permanently.");
   $ignore = _("Permanent Delete buttons on the message list page remove the selected messages from the folder permanently.");
}



