<?php

/**
  * SquirrelMail Bypass Trash Plugin
  * Copyright (c) 2009 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage bypass_trash
  *
  */



// set up SquirrelMail environment
//
if (file_exists('../../include/init.php')) 
   include_once('../../include/init.php');
else if (file_exists('../../include/validate.php')) 
{
   define('SM_PATH', '../../');
   include_once(SM_PATH . 'include/validate.php');
} 
else 
{
// not compatible with SM version less than 1.4.0
die('Sorry, Bypass Trash is not compatible with SquirrelMail versions less than 1.4.0');
   chdir('..');
   define('SM_PATH', '../');
   include_once(SM_PATH . 'src/validate.php');
}



// Make sure plugin is activated!
//
if (!in_array('bypass_trash', $plugins))
   exit;



// process a delete request
//
if (sqGetGlobalVar('dbt', $delete_bypass_trash, SQ_GET) && !empty($delete_bypass_trash)
 && sqGetGlobalVar('mailbox', $mailbox, SQ_GET) && !empty($mailbox)
 && sqGetGlobalVar('startMessage', $startMessage, SQ_GET)
 && sqGetGlobalVar('location', $location, SQ_GET)
 && sqGetGlobalVar('passed_id', $passed_id, SQ_GET) && !empty($passed_id))
{

   include_once(SM_PATH . 'functions/imap.php');

   $mailbox = urldecode($mailbox);
   $location = urldecode($location);
   $uids = array($passed_id);


   global $username, $imapServerAddress, $imapPort;
   $key = FALSE;
   if (!check_sm_version(1, 5, 2))
      sqgetGlobalVar('key', $key, SQ_COOKIE);
//TODO: in future, for 1.5.2, we should be able to use the last argument to tell this function (sqimap_login) to return any errors.... in which case we have to inspect the return value and handle errors ourselves if there are any
   $imap_stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);


   // 1.5.x
   //
   if (check_sm_version(1, 5, 2))
   {

      include_once(SM_PATH . 'functions/mailbox_display.php');

      global $mailbox_cache;
      sqgetGlobalVar('mailbox_cache', $mailbox_cache, SQ_SESSION);
      sqGetGlobalVar('account', $account, SQ_GET, 0);
      sqGetGlobalVar('what', $what, SQ_GET, 0);
      $what = urldecode($what);
      $aMailbox = sqm_api_mailbox_select($imap_stream, $account, $mailbox,
                                         array('setindex' => $what,
                                               'offset' => $startMessage),
                                         array());

      $error = handleMessageListForm($imap_stream, $aMailbox, 'setDeleted', $uids, '', TRUE);
      if (!empty($error))
      {
         // TODO: use correct error output mechanism
         //
         echo $error;
         exit;
      }


      // update cache
      //
      $mailbox_cache[$account . '_' . $aMailbox['NAME']] = $aMailbox;
      sqsession_register($mailbox_cache, 'mailbox_cache');

   }


   // 1.4.x
   //
   else
   {
      global $move_to_trash, $auto_expunge, $show_num;
      $cnt = count($uids);

      $mbx_response = sqimap_mailbox_select($imap_stream, $mailbox);

      // temporarily change "move to trash" setting so message is purged
      //
      $orig_move_to_trash = $move_to_trash;
      $move_to_trash = FALSE;
      sqimap_msgs_list_delete($imap_stream, $mailbox, $uids);
      $move_to_trash = $orig_move_to_trash;

      if ($auto_expunge)
         $cnt = sqimap_mailbox_expunge($imap_stream, $mailbox, true);
      if (($startMessage+$cnt-1) >= $mbx_response['EXISTS'])
      {
         if ($startMessage > $show_num)
            $location = set_url_var($location,'startMessage',$startMessage-$show_num, false);
         else
            $location = set_url_var($location,'startMessage',1, false);
      }

   }

   sqimap_logout($imap_stream);
   header("Location: $location");
   exit;

}



