<?php

/**
  * bypass_trash_options.tpl
  *
  * Template for showing user-configurable options on the folder page
  * for the Bypass Trash plugin.
  *
  * The following variables are available in this template:
  *
  * string  $bt_purge_button_description The text that explains what the purge 
  *                                      button does to end users.
  * string  $bypass_trash_description The text that explains what the bypass
  *                                   trash checkbox does to end users.
  * boolean $bt_show_purge_button_allow_override Whether or not users are allowed
  *                                              to change the folders that purge
  *                                              buttons are shown on.
  * boolean $show_bypass_trash_checkbox_allow_override Whether or not users are
  *                                                    allowed to change the folders
  *                                                    that bypass trash checkboxes
  *                                                    are shown on.
  * array   $bt_folder_listing   An array where each entry is a five-element
  *                              array keyed by "displayable", "option_value",
  *                              "bt_show_purge_button", "show_bypass_trash_checkbox"
  *                              and "is_special", where the last three are boolean
  *                              values.
  * boolean $javascript_on       Whether or not JavaScript is supported/enabled.
FIXME: sync the $color array with 1.5.2 if it is no longer available(?)
  * array   $color               The SquirrelMail colors array.
  *
  * Copyright (c) 2003-2009 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage bypass_trash
  *
  */


// retrieve the template vars
//
extract($t);


$form_index = 1;


if ($bt_show_purge_button_allow_override && $show_bypass_trash_checkbox_allow_override)
   $title = _("Bypass Trash Button/Checkbox");
else if ($show_bypass_trash_checkbox_allow_override)
   $title = _("Bypass Trash Checkbox");
else
   $title = _("Bypass Trash Button");



?>
<form style="display:inline; margin:0" method="post" name="bypass_trash_links_form">
  <input type="hidden" value="1" name="bypass_trash_form">
    <table width="70%" cols="1" align="center" cellpadding="4" cellspacing="0" border="0">
      <?php if (!check_sm_version(1, 4, 10)) echo "<tr><td bgcolor=\"$color[4]\">&nbsp;</td></tr>\n"; ?>
      <tr>
        <td bgcolor="<?php echo $color[9]; ?>" align="center"><strong><?php echo $title; ?></strong></td>
      </tr>
      <tr>
        <td bgcolor="<?php echo $color[0]; ?>" align="center"><?php



// where to show bypass trash checkbox?
//
if ($show_bypass_trash_checkbox_allow_override) {

        ?><table width="100%" border="0">
            <tr>
              <td width="60%" align="right">
                <select name="bt_show_bypass_trash_checkbox[]" multiple size="8">
                  <?php foreach ($bt_folder_listing as $folder_info) { ?>
                    <option value="<?php echo $folder_info['option_value']; if ($folder_info['show_bypass_trash_checkbox']) echo '" selected="selected'; ?>"><?php echo $folder_info['displayable']; ?></option>
                  <?php } ?>
                </select>
              </td>
              <td valign="bottom">
                <table cellpadding="0" cellspacing="5" border="0">
                  <tr>
                    <td><?php echo _($bypass_trash_description) . '<br /><br />'; if ($javascript_on) { 
   // "elements[x] below because javascript can't reference
   // element names with brackets in them */
?>
                <a href="#" onClick="list = document.bypass_trash_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) if (<?php
                   $first = TRUE;
                   foreach ($bt_folder_listing as $folder_info)
                   {
                      if (!$folder_info['is_special']) continue;
                      if (!$first) echo ' || ';
                      else $first = FALSE;
                      echo 'list.options[i].value==\'' . $folder_info['option_value'] . '\'';
                   }
                ?>) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle Special Folders"); ?></a>
                <br />
                <br />
                <a href="#" onClick="list = document.bypass_trash_links_form.elements[<?php echo $form_index; $form_index++; ?>]; for (i = 0; i < list.length; i++) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle All"); ?></a>
              <?php } ?></td></tr></table></td>
            </tr>
          </table>


<?php }


// where to show purge buttons?
//
if ($bt_show_purge_button_allow_override) {

   if ($show_bypass_trash_checkbox_allow_override)
      echo '<hr width="75%" />';

        ?><table width="100%" border="0">
            <tr>
              <td width="60%" align="right">
                <select name="bt_show_purge_button[]" multiple size="8">
                  <?php foreach ($bt_folder_listing as $folder_info) { ?>
                    <option value="<?php echo $folder_info['option_value']; if ($folder_info['bt_show_purge_button']) echo '" selected="selected'; ?>"><?php echo $folder_info['displayable']; ?></option>
                  <?php } ?>
                </select>
              </td>
              <td valign="bottom">
                <table cellpadding="0" cellspacing="5" border="0">
                  <tr>
                    <td><?php echo _($bt_purge_button_description) . '<br /><br />'; if ($javascript_on) {
   // "elements[x] below because javascript can't reference
   // element names with brackets in them */
?>
                <a href="#" onClick="list = document.bypass_trash_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) if (<?php
                   $first = TRUE;
                   foreach ($bt_folder_listing as $folder_info)
                   {
                      if (!$folder_info['is_special']) continue;
                      if (!$first) echo ' || ';
                      else $first = FALSE;
                      echo 'list.options[i].value==\'' . $folder_info['option_value'] . '\'';
                   }
                ?>) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle Special Folders"); ?></a>
                <br />
                <br />
                <a href="#" onClick="list = document.bypass_trash_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle All"); ?></a>
              <?php } ?></td></tr></table></td>
            </tr>
          </table>


<?php } ?>


        </td>
      </tr>
      <tr>
        <td bgcolor="<?php echo $color[0]; ?>" align="right"><input type="submit" value="<?php echo _("Save"); ?>"></td>
      </tr>
      <tr><td bgcolor="<?php echo $color[4]; ?>">&nbsp;</td></tr>
    </table>
  </form>

