<?php
/* $Id: bounce_send.php,v 1.6 2004/04/16 21:59:39 indiri69 Exp $ */
/* Path for SquirrelMail required files. */
define('SM_PATH','../../');
define('DEBUG', false);

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/imap.php');
require_once('bounce_identity.php');

global $uid_support, $domain, $username, $skip_SM_header;

sqgetGlobalVar('key',            $key,          SQ_COOKIE);
sqgetGlobalVar('username',       $username,     SQ_SESSION);
sqgetGlobalVar('onetimepad',     $onetimepad,   SQ_SESSION);
sqgetGlobalVar('mailbox',        $mailbox,      SQ_FORM);
sqgetGlobalVar('passed_id',      $passed_id,    SQ_FORM);
sqgetGlobalVar('passed_ent_id',  $passed_ent_id,SQ_FORM);
sqgetGlobalVar('send_to',        $send_to,      SQ_FORM);
sqgetGlobalVar('send_cc',        $send_cc,      SQ_FORM);
sqgetGlobalVar('send_bcc',       $send_bcc,     SQ_FORM);
sqgetGlobalVar('startMessage',   $startMessage, SQ_FORM);
sqgetGlobalVar('sort',           $sort,         SQ_FORM);
sqGetGlobalVar('REMOTE_ADDR',    $REMOTE_ADDR,  SQ_SERVER);
sqGetGlobalVar('REMOTE_PORT',    $REMOTE_PORT,  SQ_SERVER);
sqGetGlobalVar('REMOTE_HOST',    $REMOTE_HOST,  SQ_SERVER);
if(!sqgetGlobalVar('identity', $identity, SQ_FORM)) {
    $identity = 0;
}
/* if server var SERVER_NAME not available, use $domain */
if(!sqGetGlobalVar('SERVER_NAME', $SERVER_NAME, SQ_SERVER)) {
    $SERVER_NAME = $domain;
}

$idents = get_identities();

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
if(!$imapConnection) {
    exit;
}
$mbx_response   = sqimap_mailbox_select($imapConnection, $mailbox);

$message = sqimap_get_message($imapConnection, $passed_id, $mailbox);
$header_fetch = '';
if(isset($passed_ent_id)) {
    $message = $message->getEntity($passed_ent_id);
    $header_fetch = $passed_ent_id . '.';
}

/*
   Code stolen from Deliver class.  We can't use the deliver class because
   it will generate a Message-ID which we don't want
   This might be easier if parseHeader stored all headers instead of just
   specific ones
 */
$hdr = sqimap_run_command ($imapConnection, "FETCH $passed_id BODY[" . $header_fetch . "HEADER]", true, $response, $msg, $uid_support);

if (is_array($hdr)) {
    $hdr = implode('', $hdr);
}
/* First we replace \r\n by \n and unfold the header */
$hdr = trim(str_replace(array("\r\n", "\n\t", "\n "),array("\n", ' ', ' '), $hdr));

/* Now we can make a new header array with */
/* each element representing a headerline  */
$hdr = explode("\n" , $hdr);

$header = array();
$rn = "\r\n";
/* This creates an RFC 822 date */
$date = date('D, j M Y H:i:s ', mktime()) . timezone();

/* Create a message-id */
$message_id = '<' . $REMOTE_PORT . '.' . $REMOTE_ADDR . '.';
$message_id .= time() . '.squirrel.bounce@' . $REMOTE_ADDR .'>';

if (isset($REMOTE_HOST)) {
    $received_from = "$REMOTE_HOST ([$REMOTE_ADDR])";
} else {
    $received_from = $REMOTE_ADDR;
}

if (!isset($skip_SM_header) || !$skip_SM_header) {
    $header[] = "Received: from $received_from" . $rn;
    $header[] = "        (SquirrelMail authenticated user $username);" . $rn;
    $header[] = "        by $SERVER_NAME with HTTP;" . $rn;
    $header[] = "        $date" . $rn;
}
foreach ($hdr as $line) {
    $pos = strpos($line, ':');
    if ($pos > 0) {
        $field = substr($line, 0, $pos);
        if (!strstr($field,' ')) { /* valid field */
            $value = trim(substr($line, $pos+1));
            /* Change Received and all ReSent- headers to
               X-Received and X-ReSent-
             */
            if(preg_match("/^(Received|Re[sS]ent-.*)/", $field)) {
                $header[] = "X-$field: $value" . $rn;
            } else {
                /* Message: is only meaningful in digests
                   (and my sendmail/procmail seems to take issue with it).
                   We'll let the system set the Return-Path
                 */
                if($field != 'Return-Path' && $field != 'Message') {
                    $header[] = "$field: $value" . $rn;
                }
            }
        }
    }
}

$temp_message = new Message();
$temp_header  = new Rfc822Header();

$temp_header->parseField('To', $send_to);
$temp_header->parseField('Cc', $send_cc);
$temp_header->parseField('Bcc', $send_bcc);

/* More stuff stolen from elsewhere */
if (ereg("^([^@%/]+)[@%/](.+)$", $username, $usernamedata)) {
   $popuser = $usernamedata[1];
   $domain  = $usernamedata[2];
   unset($usernamedata);
} else {
   $popuser = $username;
}

$from_addr = $idents[$identity]['email_address'];
$full_name = $idents[$identity]['full_name'];
if (!$from_addr) {
   $from_addr = "$popuser@$domain";
}
$temp_header->from = $temp_header->parseAddress($from_addr,true);
if ($full_name) {
    $from = $temp_header->from[0];
    if (!$from->host) $from->host = $domain;
    $full_name_encoded = encodeHeader($full_name);
    if ($full_name_encoded != $full_name) {
        $from_addr = $full_name_encoded .' <'.$from->mailbox.'@'.$from->host.'>';
    } else {
        $from_addr = '"'.$full_name .'" <'.$from->mailbox.'@'.$from->host.'>';
    }
    $temp_header->from = $temp_header->parseAddress($from_addr,true);
}

$from_addr = $temp_header->getAddr_s('from', ',', true);
$to_addr   = $temp_header->getAddr_s('to', ',', true);
$cc_addr   = $temp_header->getAddr_s('cc', ',', true);
$bcc_addr  = $temp_header->getAddr_s('bcc', ',', true);

$header[] = 'ReSent-Date: ' . $date . $rn;
$header[] = 'ReSent-From: ' . $from_addr . $rn;
if($to_addr != '')
    $header[] = 'ReSent-To: ' . $to_addr . $rn;
if($cc_addr != '')
    $header[] = 'ReSent-Cc: ' . $cc_addr . $rn;
$header[] = 'ReSent-Message-ID: ' . $message_id . $rn;

$temp_message->rfc822_header = $temp_header;

/* Taken from compose.php */
if(!$useSendmail) {
    require_once(SM_PATH . 'class/deliver/Deliver_SMTP.class.php');
    $deliver = new Deliver_SMTP();
    global $smtpServerAddress, $smtpPort, $pop_before_smtp, $smtp_auth_mech;

    $authPop = (isset($pop_before_smtp) && $pop_before_smtp) ? true : false;
    if(!function_exists('get_smtp_user')) {
        /**-
         * Fillin user and password based on SMTP auth settings.
         *
         * @global
         * @param string $user Reference to SMTP username
         * @param string $pass Reference to SMTP password (unencrypted)
         */
        function get_smtp_user(&$user, &$pass) {
            global $username, $smtp_auth_mech,
                   $smtp_sitewide_user, $smtp_sitewide_pass;

            if ($smtp_auth_mech == 'none') {
                $user = '';
                $pass = '';
            } elseif ( isset($smtp_sitewide_user) && isset($smtp_sitewide_pass) ) {
                $user = $smtp_sitewide_user;
                $pass = $smtp_sitewide_pass;
            } else {
                global $key, $onetimepad;
                $user = $username;
                $pass = OneTimePadDecrypt($key, $onetimepad);
            }
        }
    }
    get_smtp_user($user, $pass);
    if (DEBUG) sm_print_r('Initializing stream:', $temp_message, $domain, $smtpServerAddress,
                $smtpPort, $user, $pass, $authPop);
    $stream = $deliver->initStream($temp_message,$domain,0,
                      $smtpServerAddress, $smtpPort, $user, $pass, $authPop);
    if(!$stream) {
        include_once(SM_PATH . 'functions/i18n.php');
        bindtextdomain('bounce', SM_PATH . 'plugins/bounce/locale');
        textdomain('bounce');

        $msg  = $deliver->dlv_msg . '<br />' .
                _("Server replied: ") . $deliver->dlv_ret_nr . ' '.
                $deliver->dlv_server_msg;
        plain_error_message($msg, $color);

        bindtextdomain('squirrelmail', SM_PATH . 'locale');
        textdomain('squirrelmail');
        exit;
    }
} else {
    require_once(SM_PATH . 'class/deliver/Deliver_SendMail.class.php');
    global $sendmail_path;
    $deliver = new Deliver_SendMail();
    $stream = $deliver->initStream($temp_message,$sendmail_path);
}

/* Fold our header lines back up */
$cnt = count($header);
$hdr_s = '';
for ($i = 0 ; $i < $cnt ; $i++) {
    $sKey = substr($header[$i],0,strpos($header[$i],':'));
    switch ($sKey)
    {
    case 'Message-ID':
    case 'ReSent-Message-ID':
    case 'In-Reply_To':
        $hdr_s .= $header[$i];
        break;
    case 'References':
        $sRefs = substr($header[$i],12);
        $aRefs = explode(' ',$sRefs);
        $sLine = 'References:';
        foreach ($aRefs as $sReference) {
            if (strlen($sLine)+strlen($sReference) >76) {
                $hdr_s .= $sLine;
                $sLine = $rn . '    ' . $sReference;
            } else {
                $sLine .= ' '. $sReference;
            }
        }
        $hdr_s .= $sLine;
        break;
    default: $hdr_s .= $deliver->foldLine($header[$i], 78, str_pad('',4)); break;
    }
}
$body = sqimap_run_command ($imapConnection, "FETCH $passed_id BODY[" . $header_fetch . "TEXT]", true, $response, $msg, $uid_support);
$body = array_slice($body, 1, -1);
$body = implode('', $body);

$deliver->clean_crlf($body);

$deliver->preWriteToStream($hdr_s);
if (DEBUG) sm_print_r('Writing header', $hdr_s);
$deliver->writeToStream($stream, $hdr_s);

$deliver->preWriteToStream($body);
if (DEBUG) sm_print_r('Writing body', $body);
$deliver->writeToStream($stream, $body);

if (DEBUG) sm_print_r('Finalizing stream');
$deliver->finalizeStream($stream);

/* Go back to the message list just like compose does */
$location = get_location();
$pos = strpos($location, 'plugin');
if($pos) {
    $location = substr($location, 0, $pos-1);
}
$urlMailbox = urlencode($mailbox);
$location .= '/src/right_main.php?mail_sent=yes' .
             "&mailbox=$urlMailbox" .
             "&startMessage=$startMessage" .
             "&passed_id=$passed_id";
if(isset($passed_ent_id)) {
    $location .= '&passed_ent_id=' . $passed_ent_id;
}
if(isset($sort)) {
    $location .= '&sort=' . $sort;
}
Header("Location: $location");

/* Taken from the Deliver class.  Not sure why it isn't a function available
   everywhere.
 */

/**
 * function timezone - Time offset for correct timezone
 *
 * @return string $result with timezone and offset
 */
function timezone () {
    global $invert_time;

    $diff_second = date('Z');
    if ($invert_time) {
        $diff_second = - $diff_second;
    }
    if ($diff_second > 0) {
        $sign = '+';
    } else {
        $sign = '-';
    }
    $diff_second = abs($diff_second);
    $diff_hour = floor ($diff_second / 3600);
    $diff_minute = floor (($diff_second-3600*$diff_hour) / 60);
    $zonename = '('.strftime('%Z').')';
    $result = sprintf ("%s%02d%02d %s", $sign, $diff_hour, $diff_minute,
                   $zonename);
    return ($result);
}

?>
