<?php

    require_once(SM_PATH . 'functions/global.php');

    function squirrelmail_plugin_init_bounce() {
        global $squirrelmail_plugin_hooks;

        if(check_sm_version(1,5,0)) {
            $squirrelmail_plugin_hooks['read_body_menu_top']['bounce'] = 'bounce_menu_1_5';
        } else {
            $squirrelmail_plugin_hooks['read_body_header_right']['bounce'] = 'bounce_menu_1_4';
        }
    }

    function bounce_menu_1_5($data) {
        $link = bounce_make_link();
        $str = substr($data[0], 0, -18);
        $data[0] = $str . '&nbsp;&nbsp;&nbsp;&nbsp;[<a href="' . $link . '">Bounce</a>]</small></td></tr>';
        return $data;
    }

    function bounce_menu_1_4($data) {
        $link = bounce_make_link();
        echo '&nbsp;|&nbsp;<a href="' . $link . '">Bounce</a>';
    }

    function bounce_make_link() {
        sqgetGlobalVar('mailbox', $mailbox);
        sqgetGlobalVar('passed_id', $passed_id);
        sqgetGlobalVar('passed_ent_id', $passed_ent_id);
        sqgetGlobalVar('startMessage', $startMessage);
        sqgetGlobalVar('sort', $sort);

        $mailbox = urlencode($mailbox);
        $link = SM_PATH . 'plugins/bounce/bounce.php?mailbox=' . $mailbox .
                '&amp;passed_id=' . $passed_id;
        if(isset($passed_ent_id) && trim($passed_ent_id) != '') {
            $link .= '&amp;passed_ent_id=' . $passed_ent_id;
        }
        $link .= '&amp;startMessage=' . $startMessage;
        if(isset($sort)) {
            $link .= '&amp;sort=' . $sort;
        }
        return $link;
    }

    function bounce_version() {
        return '0.1-1.4.x';
    }
?>
