<?php
/* Path for SquirrelMail required files. */
define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/identity.php');
require_once(SM_PATH . 'functions/imap.php');

sqgetGlobalVar('key',        $key,        SQ_COOKIE);
sqgetGlobalVar('username',   $username,   SQ_SESSION);
sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
sqgetGlobalVar('mailbox',    $mailbox,    SQ_GET);
sqgetGlobalVar('passed_id',  $passed_id,  SQ_GET);
sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_GET);
sqgetGlobalVar('startMessage', $startMessage);
sqgetGlobalVar('sort', $sort);

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
$mbx_response   = sqimap_mailbox_select($imapConnection, $mailbox);

$message = sqimap_get_message($imapConnection, $passed_id, $mailbox);
if(isset($passed_ent_id)) {
    $message = $message->getEntity($passed_ent_id);
}
$orig_header = $message->rfc822_header;

/* Use some of the identity code from compose */
$from_o = $orig_header->from;
if (is_object($from_o)) {
    $orig_from = $from_o->getAddress();
} else {
    $orig_from = '';
}

$identity = 0;
$idents = get_identities();
displayPageHeader($color, $mailbox);
if (count($idents) > 1) {
    foreach($idents as $nr=>$data) {
        $enc_from_name = '"'.$data['full_name'].'" <'. $data['email_address'].'>';
        if($enc_from_name == $orig_from) {
            $identity = $nr;
            break;
        }
        $identities[] = $enc_from_name;
    }

    $identity_match = $orig_header->findAddress($identities);
    if ($identity_match) {
        $identity = $identity_match;
    }
}

echo '<form action="' . SM_PATH . 'plugins/bounce/bounce_send.php" method="get">' . "\n";
echo '<input type="hidden" name="mailbox" value="' . $mailbox . '">' . "\n";
echo '<input type="hidden" name="passed_id" value="' . $passed_id . '">' . "\n";
if(isset($passed_ent_id)) {
    echo '<input type="hidden" name="passed_ent_id" value="' . $passed_ent_id . '">' . "\n";
}
echo '<input type="hidden" name="startMessage" value="' . $startMessage . '">' . "\n";
if(isset($sort)) {
    echo '<input type="hidden" name="sort" value="' . $sort . '">' . "\n";
}
echo '    <table align="center" cellspacing="0" border="0">' . "\n";

/* display select list for identities */
/* also stolen from compose.php */
if (count($idents) > 1) {
    $ident_list = array();
    foreach($idents as $id => $data) {
        $ident_list[$id] = $data['full_name'].' <'.$data['email_address'].'>';
    }
    echo "<tr>\n" .
         html_tag( 'td', '', 'right', $color[4], 'width="10%"' ) . _("From:") . "</td>\n" .
         html_tag( 'td', '', 'left', $color[4], 'width="90%"' ) .  '         ';
    echo '<select name="identity">' . "\n";
    foreach($ident_list as $value => $name) {
        echo '<option value="' . $value . '"';
        if($value == $identity) {
            echo ' selected';
        }
        echo '>' . htmlspecialchars($name) . "</option>\n";
    }
    echo '</select>';
    echo "      </td>\n</tr>\n";
}
echo "<tr>\n" .
     html_tag('td', '', 'right', $color[4], 'width="10%"') . _("To:") . "</td>\n" .
     html_tag('td', '', 'left', $color[4], 'width="90%"') .
     '<input type="text" name="send_to" value="" size="60"></td>' . "\n</tr>\n";
echo "<tr>\n" .
     html_tag('td', '', 'right', $color[4], 'width="10%"') . _("Cc:") . "</td>\n" .
     html_tag('td', '', 'left', $color[4], 'width="90%"') .
     '<input type="text" name="send_cc" value="" size="60"></td>' . "\n</tr>\n";
echo "<tr>\n" .
     html_tag('td', '', 'right', $color[4], 'width="10%"') . _("Bcc:") . "</td>\n" .
     html_tag('td', '', 'left', $color[4], 'width="90%"') .
     '<input type="text" name="send_bcc" value="" size="60"></td>' . "\n</tr>\n";
echo "<tr>\n" . '<td>' .
     html_tag('td', '', 'left', $color[4], 'width="90%"') .
     '<input type="submit" value="' . _("Send") . '">' . '</td></tr>';
?>
    </table>
</form>
</body></html>
