<?php
/*
   Block Sender - A Plugin for SqurrelMail
   Version: 2.02
   Version Date: 16-May-2003
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: setup.php

DATE          AUTHOR   CHANGE
=============================================================================
10-Oct-2002   F.Lewenda   Added i18n support
21-Feb-2002   ddb      Completion of original version
24-Feb-2002   ddb      Modified info passed to block_sender page from
                       block_sender_link()
25-Jul-2002   ddb      Added wildcard domain blocking
10-Oct-2002   fl       Added i18n support
14-Nov-2002   ddb      Added support for SM >= 1.2.8
16-May-2003   ddb      Added support for SM 1.4.
 
Registers hooks for the plug; provides functions for these initial hooks.
*/

// Required for installation of hook into SM
function squirrelmail_plugin_init_block_sender()
{
   global $squirrelmail_plugin_hooks;
   $squirrelmail_plugin_hooks['read_body_header_right']['block_sender'] = 'block_sender_link';
   $squirrelmail_plugin_hooks['optpage_register_block']['block_sender'] = 'block_sender_optionLink';
}


// Create the title, link and desc on the SM options page
function block_sender_optionLink()
{
   global $optpage_blocks;
   $optpage_blocks[] = array(
         'name' => _("Blocked Senders List"),
         'url' => '../plugins/block_sender/options.php',
         'desc' => _("View and edit the addresses currently being blocked."),
         'js' => FALSE
   );
}

// Create the link on the mail message page for blocking the current sender
function block_sender_link()
{
   if(is_array($_SERVER))
      $REQUEST_URI = $_SERVER["REQUEST_URI"]; // Message info contained in the URL
   else
   {
      global $_SERVER;
      $REQUEST_URI = $_SERVER["REQUEST_URI"];
   }
  
   $msgInfo = substr($REQUEST_URI, strpos($REQUEST_URI, "?")+1);
   echo "<br><a href=\"../plugins/block_sender/block_sender.php?$msgInfo\">" . _("Block Sender") . "</a>";
   echo "<br><a href=\"../plugins/block_sender/block_sender.php?$msgInfo&block_dom=1\">" . _("Block Sender's Domain") . "</a>";
}

?>
