<?php
/*
   Block Sender - A Plugin for SqurrelMail
   Version: 2.02
   Version Date: 16-May-2003
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: options.php

DATE          AUTHOR   CHANGE
=============================================================================
21-Feb-2002   ddb      Completion of original version
10-Oct-2002   fl       Added i18n support
14-Nov-2002   ddb      Added support for SM >= 1.2.8
16-May-2003   ddb      Added support for SM 1.4.

Contains code for the options page.  The options page for this plugin allows
the user to modify their blocked senders list.
*/

define('SM_PATH', '../../');
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/page_header.php');
$blockFile = $data_dir . $username . ".block";
?>

<html>
<?php displayPageHeader($color, 'None'); ?>

<br>
<table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td
 bgcolor="<?php echo $color[0] ?>">
         <center><b><?php echo _("Options") . " - " . _("Blocked Senders List") ?></b></center>
      </td></tr>
<tr><td>
<?php
if(!is_array($_POST))
   global $_POST;
if(!is_array($_SERVER))
   global $_SERVER;
$PHP_SELF = $_SERVER["PHP_SELF"];

if(isset($_POST["action"]) && $_POST["action"] == "editList")
{
   $blockList = $_POST["blockList"];
   echo "<p>";
   switch(writeList($blockList, $blockFile))
   {
      case TRUE:
          echo "<b><i>" . _("Your blocked list has been updated!") . "</i></b>";
          break;
      default:
          echo "<b><i>" . _("There was an error updating your blocked list!  Please try again or report this error to your system administrator if this problem continues!") . "</i></b>";
   }
   echo "</p>\n";
}
?>

<p>
<?php echo _("The list below shows all of the addresses that are currently being blocked.  Any e-mail received from addresses listed below will be automatically delivered to your <b>Trash</b> folder.  You may remove or add addresses to your list below.  Addresses must be listed <b>one</b> per line.  To block mail from an entire domain enter <b>*@doman-to-block.com</b>.  Click on \"Update List\" when done.") ?>
</p>

<p align="center">
<form action="<?php echo $PHP_SELF; ?>" method="POST">
   <input type="hidden" name="action" value="editList">
<textarea name="blockList" rows="15" cols="60">
<?php @readfile($blockFile); ?>
</textarea><br>
   <input type="submit" name="submit" value="<?php echo _("Update List") ?>">
</form></p></td></tr></table>
</body>
</html>

<?php
// Given the update list, $list, write it to the file, $file
function writeList($list, $file)
{
   if($fp = fopen($file, "w"))
   {
      fputs($fp, $list);
      if($list != "")
         fputs($fp, "\n");
   }
   return fclose($fp);
}
?>
