<?php
/*
   Block Sender - A Plugin for SqurrelMail
   Version: 2.02
   Version Date: 16-May-2003
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: block_sender.php

DATE          AUTHOR   CHANGE
=============================================================================
21-Feb-2002   ddb      Completion of original version
24-Feb-2002   ddb      Auto delete blocked messages; going back to the message
                       sometimes causes an error with the IMAP server.
25-Feb-2002   ddb      Modified the regex that parses the e-mail address from
                       the From: header of the message.  E-mail addresses with
                       a period in the id portion of the address were not being
                       properly parsed from the header.
25-Jul-2002   ddb      Added the ability to block based on sender's domain.
                       Format for manual addition is *@domain.to.block
10-Oct-2002   fl       Added i18n support
14-Nov-2002   ddb      Added support for SM >= 1.2.8
16-May-2003   ddb      Added support for SM 1.4.

When a user clicks on "Block Sender" this is the code that adds the sender to
the block list along with printing out the page that reports what has happened.
*/

define('SM_PATH', '../../');
include_once(SM_PATH . 'functions/i18n.php');
include_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'functions/page_header.php');

function block_sender($mailbox, $passed_id, $return, $block_dom = false)
{
// Declare the globals being used
   if(!is_array($_SERVER))
      global $_SERVER;
   if(!is_array($_COOKIE))
      global $_COOKIE;
   if(!is_array($_SESSION))
      global $_SESSION;
   $key = $_COOKIE["key"];
   $username = $_SESSION["username"];
   $REQUEST_URI = $_SERVER["REQUEST_URI"]; // Where we need to return to

   global $imapServerAddress,
          $imapPort,
          $auto_expunge,
          $sort,
          $data_dir,
          $onetimepad;
          $onetimepad = $_SESSION["onetimepad"]; // Need to set this global

// Set the return URL
   $return = "../../src/right_main.php?sort=" . urlencode($sort) . "&startMessage=1&mailbox=" . urlencode($mailbox);
// Grab the message in question from the IMAP server along with the from header
   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 1);
   sqimap_mailbox_select($imapConnection, $mailbox);
   $message = sqimap_get_message($imapConnection, $passed_id, $mailbox); 
//   sqimap_logout($imapConnection);
   $fromHdr = $message->rfc822_header->from[0]->mailbox . "@" . $message->rfc822_header->from[0]->host;
// Get the bare email address from the from header, if we can't then bail out
   if(!preg_match("/([-.\w]+\@[A-Za-z0-9]+[-A-Za-z0-9.]+\.[A-Za-z0-9]+)/", $fromHdr, $matches))
   {
      echo "<h4>" . _("Can't determine sender's e-mail address!  Nothing added to block list!") . "</h4>\n";
      echo "<h4><a href=\"$return\">" . _("Click Here to Return to the Message List") . "</a></h4>\n";
      return;
   }

   // If the user wants to block the entire domain then modify the address
   if($block_dom)
   {
      $fromHdr = "*@" . substr($fromHdr, strpos($fromHdr, "@")+1);
      $searchHdr = "\\" . $fromHdr;
   }
   else
      $searchHdr = $fromHdr;

   $blockFile = $data_dir . $username . ".block";

   // Check if the sender is already in the block list, if so then bail out
   if(file_exists($blockFile))
   {
      $blockAddrs = file($blockFile);
      if(preg_grep("/" . $searchHdr . "/", $blockAddrs))
      {
         echo "<h4>$fromHdr " . _("is already on your block list!  Please contact your system administrator if you're not reading this message from your Trash folder!") . "</h4>\n";
         echo "<h4><a href=\"$return\">" . _("Click Here to Return to the Message List") . "</a></h4>";
         return;
      }
   }

   // Attempt to add the sender to the block list; report errors
   if(!$fp = fopen($blockFile, "a"))
      echo "<h4>" . _("Can't open block list!  Address not added!") . "</h4>\n";
   else
   {
      fputs($fp, "$fromHdr\n");
      fclose($fp);
      echo "<h4>$fromHdr " . _("has been successfully added to your blocked list!") . "</h4>";
      sqimap_messages_delete($imapConnection, $passed_id, $passed_id, $mailbox);
      if($auto_expunge)
         sqimap_mailbox_expunge($imapConnection, $mailbox, true); 
      echo "<h4><a href=\"$return\">" . _("Click Here to Return to the Message List") . "</a></h4>";
   }
   sqimap_logout($imapConnection);
   return;
}

// S T A R T  M A I N  B L O C K
if(!is_array($_GET))
   global $_GET;

displayPageHeader($color, 'None'); ?> 
<table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td
 bgcolor="<?php echo $color[0] ?>">
         <center><b><?php echo _("Blocked Senders List") ?></b></center></td></tr><tr><td>
<?php
$doDomain = isset($_GET["block_dom"]);
block_sender($_GET["mailbox"], $_GET["passed_id"], "", $doDomain);

?></td></tr></table></body></html>
