#!/usr/bin/perl

# Block Sender - A Plugin for SqurrelMail
# Version: 2.01
# Version Date: 06-Jan-2003
# Author: Derek Battams <derek@battams.ca>
# Please see the README file for further information
#
# File: tools/block_flat2mysql.pl
#
# DATE          AUTHOR   CHANGE
# ===========================================================================
# 06-Jan-2003   ddb      Initial version
#
# Perl script to convert flatfile block lists into a MySQL script suitable for loading into MySQL

opendir(DATADIR, $ARGV[0]) || die "Can't open data directory!";
while($entry = readdir(DATADIR))
{
   if(-f "$ARGV[0]/$entry" && $entry =~ /\.block$/)
   {
      ($user, $suffix) = split(/\./, $entry);
      &createScript("$ARGV[0]/$entry", $user); 
   } 
}
closedir(DATADIR);

sub createScript
{
   local (*DATAFILE, *SCRIPTFILE);
   my $fileName = $_[0];
   my $user = $_[1];

   open(DATAFILE, "<$fileName") || die "Can't open data file!";
   open(SCRIPTFILE, ">>blocklist.mysql") || die "Can't open script file!";
   while(my $data = <DATAFILE>)
   {
      while(substr($data, length($data) - 1) !~ /\w/)
      {
         chop $data;
      }
      print SCRIPTFILE "INSERT INTO blocked (user, email) VALUES ('$user', '$data')\;\n";
   }
   close(SCRIPTFILE);
   close(DATAFILE);
}
