<?php
/*
   Block Sender - A Plugin for SqurrelMail
   Version: 1.0 
   Version Date: 14-Nov-2002 
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: block_sender.php

DATE          AUTHOR   CHANGE
=============================================================================
21-Feb-2002   ddb      Completion of original version
24-Feb-2002   ddb      Auto delete blocked messages; going back to the message
                       sometimes causes an error with the IMAP server.
25-Feb-2002   ddb      Modified the regex that parses the e-mail address from
                       the From: header of the message.  E-mail addresses with
                       a period in the id portion of the address were not being
                       properly parsed from the header.
25-Jul-2002   ddb      Added the ability to block based on sender's domain.
                       Format for manual addition is *@domain.to.block

When a user clicks on "Block Sender" this is the code that adds the sender to
the block list along with printing out the page that reports what has happened.
*/

chdir('..');
include_once('../src/validate.php');
require_once('../functions/imap.php');
require_once('../functions/page_header.php');

function block_sender($mailbox, $passed_id, $return, $block_dom = false)
{
// Declare the globals being used
   global $REQUEST_URI, // Where we need to return to
          $username,    // User's login name
          $key,         // User's mail password
          $imapServerAddress,
          $imapPort,
          $auto_expunge,
          $sort,
          $data_dir;

// Set the return URL
   $return = "../../src/right_main.php?sort=" . urlencode($sort) . "&startMessage=1&mailbox=" . urlencode($mailbox);

// Grab the message in question from the IMAP server along with the from header
   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 1);
   sqimap_mailbox_select($imapConnection, $mailbox);
   $message = sqimap_get_message($imapConnection, $passed_id, $mailbox); 
//   sqimap_logout($imapConnection);
   $fromHdr = $message->header->from;

// Get the bare email address from the from header, if we can't then bail out
   if(preg_match("/([-.\w]+\@[A-Za-z0-9]+[-A-Za-z0-9.]+\.[A-Za-z0-9]+)/", $fromHdr, $matches))
      $fromHdr = $matches[1];
   else
   {
      echo "<h4>Can't determine sender's e-mail address!  Nothing added to block list!</h4>\n";
      echo "<h4><a href=\"$return\">Click Here to Return to the Message List</a></h4>\n";
      return;
   }

   // If the user wants to block the entire domain then modify the address
   if($block_dom)
   {
      $fromHdr = "*@" . substr($fromHdr, strpos($fromHdr, "@")+1);
      $searchHdr = "\\" . $fromHdr;
   }
   else
      $searchHdr = $fromHdr;

   $blockFile = $data_dir . $username . ".block";

   // Check if the sender is already in the block list, if so then bail out
   if(file_exists($blockFile))
   {
      $blockAddrs = file($blockFile);
      if(preg_grep("/" . $searchHdr . "/", $blockAddrs))
      {
         echo "<h4>$fromHdr is already on your block list!  Please contact your system administrator if you're not reading this message from your Trash folder!</h4>\n";
         echo "<h4><a href=\"$return\">Click Here to Return to the Message List</a></h4>";
         return;
      }
   }

   // Attempt to add the sender to the block list; report errors
   if(!$fp = fopen($blockFile, "a"))
      echo "<h4>Can't open block list!  Address not added!</h4>\n";
   else
   {
      fputs($fp, "$fromHdr\n");
      fclose($fp);
      echo "<h4>$fromHdr has been successfully added to your blocked list!</h4>";
      sqimap_messages_delete($imapConnection, $passed_id, $passed_id, $mailbox);
      if($auto_expunge)
         sqimap_mailbox_expunge($imapConnection, $mailbox, true); 
      echo "<h4><a href=\"$return\">Click Here to Return to the Message List</a></h4>";
   }
   sqimap_logout($imapConnection);
   return;
}

// S T A R T  M A I N  B L O C K
displayPageHeader($color, 'None'); ?><br>
<table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td
 bgcolor="<?php echo $color[0] ?>">
         <center><b>Blocked Senders List</b></center></td></tr><tr><td>
<?php
$doDomain = isset($block_dom);
block_sender($mailbox, $passed_id, $return, $doDomain);

?></td></tr></table></body></html>
