<?php
/*
   Block Sender - A Plugin for SqurrelMail
   Version: 0.2 (BETA)
   Version Date: 24-Feb-2002
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: setup.php

DATE          AUTHOR   CHANGE
=============================================================================
21-Feb-2002   ddb      Completion of original version
24-Feb-2002   ddb      Modified info passed to block_sender page from
                       block_sender_link()

Registers hooks for the plug; provides functions for these initial hooks.
*/

// Required for installation of hook into SM
function squirrelmail_plugin_init_block_sender()
{
   global $squirrelmail_plugin_hooks;
   $squirrelmail_plugin_hooks['read_body_header_right']['block_sender'] = 'block_sender_link';
   $squirrelmail_plugin_hooks['optpage_register_block']['block_sender'] = 'block_sender_optionLink';
}


// Create the title, link and desc on the SM options page
function block_sender_optionLink()
{
   global $optpage_blocks;
   $optpage_blocks[] = array(
         'name' => _("Blocked Senders List"),
         'url' => '../plugins/block_sender/options.php',
         'desc' => _("View and edit the addresses currently being blocked."),
         'js' => FALSE
   );
}

// Create the link on the mail message page for blocking the current sender
function block_sender_link()
{
   global $REQUEST_URI; // Message info contained in the URL
  
   $msgInfo = substr($REQUEST_URI, strpos($REQUEST_URI, "?")+1);
   echo "<br><a href=\"../plugins/block_sender/block_sender.php?$msgInfo\">Block Sender</a>";
}

?>
