<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Block Attachments
    Version ........ 0.3
    Purpose ........ Allows an admin to block any types of attachments

*******************************************************************************/

define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'include/load_prefs.php');

global $username;

if (!function_exists('adm_check_user'))
   include_once(SM_PATH . 'plugins/block_attach/includes/auth.php');

$auth = adm_check_user();
if (!$auth) header("Location " . SM_PATH . "index.php");

global $virusstrings;
include_once(SM_PATH . "plugins/block_attach/includes/scan.php");
VirusOpen();

$filename = SM_PATH . 'plugins/block_attach/blocked_attachments.php';
if (!file_exists($filename)) {
   touch($filename);
   $blocked = Array('scr','pif','bat','vbs');
   $warning = Array('exe','com');
   $excluded = Array('');
   $virusscan = 1;
   CreateBlockedArray($blocked,$warning,$excluded,$virusscan, $filename);
}

include_once($filename);

if (!isset($virusscan)) $virusscan = 1;

include_once(SM_PATH . 'plugins/block_attach/includes/display_save.php');

displayPageHeader($color, 'None');

bindtextdomain('block_attach', SM_PATH . 'plugins/block_attach/locale');
textdomain('block_attach');

print "<br><center><font size=+1>". _("Block Attachments") . "<br>". _("Admin Interface") . "</font></center>\n";
print "<center><table><form method=post action=\"" . SM_PATH . "plugins/block_attach/options.php\">\n";
print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>";
print "<tr><td colspan=2>" . _("Add a file extension") . "<br><input type=text name='newb' maxlength=5> <input type=submit name=submit value='" . _("Add") . "'><br>";
print "<input type=radio name='give' value='warning' checked>&nbsp;". _("Warning") . "&nbsp;&nbsp;&nbsp;&nbsp;";
print "<input type=radio name='give' value='block'>&nbsp;". _("Block") . "<br>";
print "</form></td>";

print '<td colspan=2><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">&nbsp;&nbsp;&nbsp;&nbsp;' . _("Add an excluded user") . '<br>';
print "&nbsp;&nbsp;&nbsp;&nbsp;<input type=text name='exu' maxlength=50><input type=submit name=submit value='" . _("Add") . "'><br><br><br>";
print "</td></tr>\n";

print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>\n<tr>";
print '<td><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Give Warning") . '<br><select name="wtypes" size=5>\n';
foreach($warning as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>*.$value</option>\n";
}
print "</select><br><input type=submit name=submit value='" . _("Remove") . "'></form></td>\n";
print '<td><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Block") . '<br><select name="btypes" size=5>\n';
foreach($blocked as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>*.$value</option>\n";
}
print "</select><br><input type=submit name=submit value='" . _("Remove") . "'></form></td>\n";


print '<td><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Excluded Users") . '<br><select name="exclude" size=5>\n';
foreach($excluded as $value) {
   if (strlen($value)>0)
      print "<option value='$value'>$value</option>\n";
}
print "</select><br><input type=submit name=submit value='" . _("Remove") . "'></form></center></td></tr>\n";

print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>";
print '<tr><td colspan=2><center><form method=post action="' . SM_PATH . 'plugins/block_attach/options.php">' . _("Virus Scan") . '&nbsp;&nbsp;<select name="vscan" size=1>';
print '<option value=0';
if ($virusscan == 0 || $virusscan == '')
   echo " SELECTED";
print  '>' . _("Disabled") . '</option>';
print '<option value=1';
if ($virusscan == 1)
   echo " SELECTED";
print  '>' . _("Enabled") . '</option></select><br><input type=submit value="' . _("Save") . '"></form></center></td><td><center>'. _("Currently scanning for") . '<br>'. count($virusstrings) . ' ' . _("viruses") . '</center></td></tr>';

print "<tr><td colspan=4><hr width='100%' color='$color[9]'></td></tr>";
print "</table></center>\n";

textdomain('squirrelmail');

function CreateBlockedArray($blocked, $warning, $excluded, $scan, $filename) {
   $string = "<?php\r\n\r\nglobal \$blocked;\r\n\r\n";
   $string .= "\$virusscan = $scan;\r\n\r\n";
   $string .= "\$excluded = Array(";
   $string .= OutputBlockedArray($excluded);
   $string .= ");\r\n\r\n";
   $string .= "\$blocked = Array(";
   $string .= OutputBlockedArray($blocked);
   $string .= ");\r\n\r\n";
   $string .= "\$warning = Array(";
   $string .= OutputBlockedArray($warning);
   $string .= ");\r\n\r\n?>";
   if ($file =  @fopen($filename, 'w')) {
      @fwrite ($file, $string);
     @fclose($file);
   }
}

function OutputBlockedArray($ar, $name = '') {
   $string = '';
   $end = count($ar);
   $c = 0;
   sort($ar);
   reset($ar);
   foreach ($ar as $key => $value) {
      $c++;
      if (!is_array($value)) {
         $string .= "'$value'";
         if ($c != $end) 
            $string .= ",\r\n";
      }
   }
   return $string;
}
?>