<?php
include_once(SM_PATH.'functions/mailbox_display.php');
include_once(SM_PATH.'plugins/bayesspam/config.php');

function bayesspam_filter($args) {
   if (!$GLOBALS['bayesspam_filtering_enabled'])
      return 0;

   if($args[0] == 'left_main_before') {
      bayesspam_filters($GLOBALS['imapConnection'], 0);
   } else {
      bayesspam_filters($GLOBALS['imapConnection'], 1);
   }
}

function bayesspam_filters(&$imap_stream, $use_mailbox=0) {
   $version_array = split('\.', $GLOBALS['version']);

   $new_spam_occurences = array();
   $new_nonspam_occurences = array();
   $spam_stats = 0;
   $ham_stats = 0;
   $unsure_stats = 0;
   $total_messages = 0;

   $run_folders = array();
   $boxes = sqimap_mailbox_list($imap_stream);
   $sid = sqimap_session_id();

   foreach ($boxes as $box) {
      if ($GLOBALS['bayesspam_inboxonly'] != 1 || ($GLOBALS['bayesspam_inboxonly'] == 1 && preg_match("/^INBOX$/", $box['unformatted-dm']))) {
         if (($use_mailbox == 1 && $box['unformatted-dm'] == $GLOBALS['mailbox'] && !in_array($box['unformatted-dm'],$GLOBALS['bayesspam_ignore_folders'])) || ($use_mailbox == 0 && !in_array($box['unformatted-dm'], $GLOBALS['bayesspam_ignore_folders']))) {
            if ( (array_search('noselect', $box['flags']) === FALSE || array_search('noselect', $box['flags']) === NULL) && !preg_match("/^INBOX\.Sent/", $box['unformatted-dm']) && sqimap_unseen_messages($imap_stream, $box['unformatted-dm']) > 0) {
               $run_folders[] = $box['unformatted-dm'];
            }
         }
      }
   }

   foreach ($run_folders as $box) {
      $spam_messages = array();
      $uncertain_messages = array();

      $mbxresponse = sqimap_mailbox_select($imap_stream, $box);

      $messages = array();
      $search = "SEARCH UNSEEN UNDELETED";
      $read = sqimap_run_command($imap_stream, $search, TRUE, $response, $message, TRUE);
      if (isset($read[0])) {
         for ($i=0,$iCnt=count($read);$i<$iCnt;++$i) {
            if (preg_match("/^\* SEARCH (.+)$/", $read[$i], $regs)) {
               $messages = preg_split("/ /", trim($regs[1]));
               break;
            }
         }
      }

      foreach ($messages as $passed_id) {
         bayesspam_set_message_id($imap_stream,$passed_id);

         $bayesspam_check_messageid = bayesspam_check_messageid();
         if ($GLOBALS['bayesspam_do_stats'] && $GLOBALS['bayesspam_do_user_stats']) {
            $bayesspam_old_message_score = bayesspam_get_old_message_score();
         }

         $is_spam = bayesspam_get_probability($imap_stream, $passed_id, 1);

         if ($is_spam>.9) {
            $spam_messages[] = $passed_id;
         } elseif ($is_spam >= .1) {
            $uncertain_messages[] = $passed_id;
         }

         if ($bayesspam_old_message_score === FALSE && $GLOBALS['bayesspam_do_stats'] && $GLOBALS['bayesspam_do_user_stats']) {
            if ($is_spam > .9) {
               $spam_stats++;
               $total_messages++;
            }
            if ($is_spam <= .9 && $is_spam >= .1) {
               $unsure_stats++;
               $total_messages++;
            }
            if ($is_spam < .1) {
               $ham_stats++;
               $total_messages++;
            }
         }
      }

      if ($spam_messages) {
         $message_str = sqimap_message_list_squisher($spam_messages);
         if ($GLOBALS['bayesspam_delete']) {
            sqimap_run_command ($imap_stream, 'STORE '.$message_str.' +FLAGS (\Deleted)', true, $response, $message, $GLOBALS['uid_support']);
         } elseif (sqimap_mailbox_exists($imap_stream, $GLOBALS['bayesspam_folder'])) {
            sqimap_run_command ($imap_stream, 'COPY '.$message_str.' "'.$GLOBALS['bayesspam_folder'].'"', true, $response, $message,  $GLOBALS['uid_support']);
            sqimap_run_command ($imap_stream, 'STORE '.$message_str.' +FLAGS (\Deleted)', true, $response, $message,  $GLOBALS['uid_support']);
         }
         sqimap_mailbox_expunge($imap_stream, $box);
      }
      if ($uncertain_messages && $GLOBALS['bayesspam_do_uncertain_filtering']) {
         $message_str = sqimap_message_list_squisher($uncertain_messages);
         if (sqimap_mailbox_exists($imap_stream, $GLOBALS['bayesspam_uncertain_folder'])) {
            sqimap_run_command ($imap_stream, 'COPY '.$message_str.' "'.$GLOBALS['bayesspam_uncertain_folder'].'"', true, $response, $message,  $GLOBALS['uid_support']);
            sqimap_run_command ($imap_stream, 'STORE '.$message_str.' +FLAGS (\Deleted)', true, $response, $message,  $GLOBALS['uid_support']);
         }
         sqimap_mailbox_expunge($imap_stream, $box);
      }
   }

   if ($GLOBALS['bayesspam_do_stats'] && $GLOBALS['bayesspam_do_user_stats']) {
      $res = $GLOBALS['bayesdbhandle']->query('SELECT UserName FROM '.$GLOBALS['bayesdbprefix'].'stats WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');

      if (DB::isError($res)) {
         echo $res->getDebugInfo();
      }
      if (!DB::isError($res) && !($row = $res->fetchRow())) {
         $GLOBALS['bayesdbhandle']->query('INSERT INTO '.$GLOBALS['bayesdbprefix'].'stats SET StatsStart=NOW(),UserName=\''.$GLOBALS['bayes_username'].'\'');
      } 

      $GLOBALS['bayesdbhandle']->query('UPDATE '.$GLOBALS['bayesdbprefix'].'stats SET TotalMessages=TotalMessages+'.$total_messages.', HamMessages=HamMessages+'.$ham_stats.',SpamMessages=SpamMessages+'.$spam_stats.', UnsureMessages=UnsureMessages+'.$unsure_stats.' WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');

      if ($GLOBALS['bayesspam_do_timing']) {
         $res = $GLOBALS['bayesdbhandle']->query('SELECT UserName FROM '.$GLOBALS['bayesdbprefix'].'stats WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
   
         if (DB::isError($res)) {
            echo $res->getDebugInfo();
         }
         if (!DB::isError($res) && !($row = $res->fetchRow())) {
            $GLOBALS['bayesdbhandle']->query('INSERT INTO '.$GLOBALS['bayesdbprefix'].'stats SET StatsStart=NOW(),UserName=\''.$GLOBALS['bayes_username'].'\'');
         }
   
         $GLOBALS['bayesdbhandle']->query('UPDATE '.$GLOBALS['bayesdbprefix'].'stats SET TimedMessages=TimedMessages+'.$GLOBALS['bayes_parsed_messages'].',TotalParseTime=TotalParseTime+'.$GLOBALS['bayes_parse_time'].' WHERE UserName=\''.$GLOBALS['bayes_username'].'\'');
      }
   }
}
?>
