<?php
require_once('../plugins/bayesspam/config.php');

/* Initialize the plugin */
function squirrelmail_plugin_init_bayesspam() {
	global $squirrelmail_plugin_hooks, $data_dir, $username, $mailbox, $bayesdbhandle, 
		$bayesdbuser, $bayesdbpass, $bayesdbhost, $bayesdbport, $bayesdbname;

	$bayesdbhandle = DB::connect("mysql://$bayesdbuser:$bayesdbpass@$bayesdbhost:$bayesdbport/$bayesdbname");
	if (DB::isError($bayesdbhandle)) {
		echo "BayesSpam improperly configured. Check DB Information.";
		return;
	}
	$bayesdbhandle->setFetchMode(DB_FETCHMODE_ASSOC);

	$squirrelmail_plugin_hooks['optpage_register_block']['bayesspam'] =
		'bayesspam_options';
	$squirrelmail_plugin_hooks['loading_prefs']['bayesspam'] =
		'bayesspam_load';
	$squirrelmail_plugin_hooks['read_body_header']['bayesspam'] =
		'bayesspam_display';
	$squirrelmail_plugin_hooks['webmail_bottom']['bayesspam'] =
		'bayesspam_rebuild_corpus_hook';
	$squirrelmail_plugin_hooks['left_main_after']['bayesspam'] =
		'bayesspam_rebuild_corpus_hook';
	$squirrelmail_plugin_hooks['left_main_before']['bayesspam'] = 
		'bayesspam_filter';
	$squirrelmail_plugin_hooks['right_main_after_header']['bayesspam'] = 
		'bayesspam_filter';


}

function bayesspam_rebuild_corpus_hook($args) {
	global $bayesspam_rebuild_on_login, $bayesspam_rebuild_on_refresh, $username;

	if($args[0] == 'webmail_bottom' && $bayesspam_rebuild_on_login) {
		bayesspam_rebuild_corpus();
	}

	if($args[0] == 'left_main_after' && $bayesspam_rebuild_on_refresh) {
		bayesspam_rebuild_corpus();
	}
}

// Load the settings
// Validate some of it (make '' into 'default', etc.)
function bayesspam_load() {
	global $username, $data_dir, $bayesspam_links_enabled, $bayesspam_delete,
		$bayesspam_folder, $bayesspam_autolearn, $bayesspam_filtering_enabled,
		$bayesspam_rebuild_on_login, $bayesspam_rebuild_on_refresh, $bayesspam_show_prob,
		$bayesspam_ignore_folders, $bayesspam_scan_size, $bayes_max_size;

	$bayesspam_links_enabled = getPref($data_dir, $username, 'bayesspam_links_enabled');
	$bayesspam_filtering_enabled = getPref($data_dir, $username, 'bayesspam_filtering_enabled');
	$bayesspam_delete = getPref($data_dir, $username, 'bayesspam_delete');
	$bayesspam_folder = getPref($data_dir, $username, 'bayesspam_folder');
	$bayesspam_autolearn = getPref($data_dir, $username, 'bayesspam_autolearn');
	$bayesspam_rebuild_on_login = getPref($data_dir, $username, 'bayesspam_rebuild_on_login');
	$bayesspam_rebuild_on_refresh = getPref($data_dir, $username, 'bayesspam_rebuild_on_refresh');
	$bayesspam_show_prob = getPref($data_dir, $username, 'bayesspam_show_prob');
	$bayesspam_scan_size = getPref($data_dir, $username, 'bayesspam_scan_size');
	
	if ($bayesspam_scan_size == '') {
		$bayesspam_scan_size = $bayes_max_size / 2;
		setPref($data_dir, $username, 'bayesspam_scan_size', $bayesspam_scan_size);
	}

	$bayesspam_ignore_folders = array();
	for ($i=0; $load = getPref($data_dir, $username, 'bayesspam_ignore_folders_'.$i); $i++) {
		$bayesspam_ignore_folders[$i] = $load;
	}

	if ($bayesspam_folder == '') {
		$bayesspam_folder = 'INBOX.Trash';
		setPref($data_dir, $username, 'bayesspam_folder', $bayesspam_folder);
	}

	if(!$bayesspam_ignore_folders) {
		$bayesspam_ignore_folders[] = 'INBOX.Trash';
		$bayesspam_ignore_folders[] = $bayesspam_folder;

		array_unique($bayesspam_ignore_folders);
		$temp = array();
		foreach ($bayesspam_ignore_folders as $value) {
			$temp[] = $value;
		}	
		$bayesspam_ignore_folders = $temp;
		
		for ($i=0; $i<count($bayesspam_ignore_folders); $i++) {
			setPref($data_dir, $username, 'bayesspam_ignore_folders_'.$i, $bayesspam_ignore_folders[$i]);
		}
	} elseif (!in_array('INBOX.Trash', $bayesspam_ignore_folders)) {
		$bayesspam_ignore_folders[] = 'INBOX.Trash';
		for ($i=0; $i<count($bayesspam_ignore_folders); $i++) {
			setPref($data_dir, $username, 'bayesspam_ignore_folders_'.$i, $bayesspam_ignore_folders[$i]);
		}
	} elseif (!in_array($bayesspam_folder, $bayesspam_ignore_folders)) {
		$bayesspam_ignore_folders[] = $bayesspam_folder;
		for ($i=0; $i<count($bayesspam_ignore_folders); $i++) {
			setPref($data_dir, $username, 'bayesspam_ignore_folders_'.$i, $bayesspam_ignore_folders[$i]);
		}
	}
}


function bayesspam_display() {
	global $imapConnection, $passed_id, $color, $bayesspam_show_prob, $bayes_debug;
	global $mailbox, $ent_num, $bayesspam_links_enabled, $startMessage, $show_more;
	global $version, $bayes_was_cached;

	$bayes_debug=1;
	$version_array = split('\.', $version);

	if ($bayesspam_show_prob) {
		$is_spam = bayesspam_get_probability($imapConnection, $passed_id);
	
		$s = '';
		$s .= "<TR BGCOLOR=\"$color[0]\">";
		if ($version_array[0] == 1 && $version_array[1] <= 2) {
			$s .=   '<TD align=right valign=top width=20%>BayesSpam Probability:</TD>'."\n";
			$s .=   '<TD align=left valign=top width=80% colspan=2><b>'. number_format($is_spam*100,2).'%';
			if ($bayes_was_cached) {
				$s .= ' (Cached)';
			} else {
				$s .= ' (Calculated)';
			}
			$s .=   '</b></td>' . "\n";
		} else {
			$s .=   '<TD align=right valign=top width=20%><b>BayesSpam Probability:&nbsp;&nbsp;</b></TD>'."\n";
			$s .=   '<TD align=left valign=top width=80% colspan=2>'. number_format($is_spam*100,2).'%';
			if ($bayes_was_cached) {
				$s .= ' (Cached)';
			} else {
				$s .= ' (Calculated)';
			}
			$s .=   '</td>' . "\n";
		}
		$s .= '</TR>';
	
		echo $s;
	}
	
	if (!$bayesspam_links_enabled) {
		return;
	}

	$s = '';

	$s .= "<TR BGCOLOR=\"$color[0]\">";
	if ($version_array[0] == 1 && $version_array[1] <= 2) {
		$s .=   '<TD align=right valign=top width=20%>BayesSpam Links:</TD>'."\n";
		$s .=   '<TD align=left valign=top width=80% colspan=2><b>';
	} else {
		$s .=   '<TD align=right valign=top width=20%><b>BayesSpam Links:&nbsp;&nbsp;</b></TD>'."\n";
		$s .=   '<TD align=left valign=top width=80% colspan=2>';	
	}
	
	if (!$bayesspam_show_prob) {
		$tokens = bayesspam_get_tokens($imapConnection,$passed_id);
	}

	$check = bayesspam_check_messageid();
	
	if ($check == 'spam') {
		$s .= 'Known As Spam</b> -- <font size=-1><a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=nonspam&passed_id='.urlencode($passed_id);
		$s .= '&mailbox='.urlencode($mailbox);
		$s .= '&startMessage='.urlencode($startMessage);
		$s .= '&show_more='.urlencode($show_more);
		$s .= '">Move To NonSpam</a> | ';
	} elseif ($check == 'nonspam') {
		$s .= 'Known As NonSpam</b> -- <font size=-1><a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=spam&passed_id='.urlencode($passed_id);
		$s .= '&mailbox='.urlencode($mailbox);
		$s .= '&startMessage='.urlencode($startMessage);
		$s .= '&show_more='.urlencode($show_more);
		$s .= '">Move To Spam</a> | ';	
	} else {
		$s .= 'Message Not In DB</b> -- <font size=-1><a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=spam&passed_id='.urlencode($passed_id);
		$s .= '&mailbox='.urlencode($mailbox);
		$s .= '&startMessage='.urlencode($startMessage);
		$s .= '&show_more='.urlencode($show_more);
		$s .= '">Learn As Spam</a> | ';
		$s .= '<a href="../plugins/bayesspam/bayesspam_learn.php?bayes_type=nonspam&passed_id='.urlencode($passed_id);
		$s .= '&mailbox='.urlencode($mailbox);
		$s .= '&startMessage='.urlencode($startMessage);
		$s .= '&show_more='.urlencode($show_more);
		$s .= '">Learn As NonSpam</a> | ';
	}
	$s .= '<a href="../src/read_body.php?passed_id='.urlencode($passed_id);
	$s .= '&mailbox='.urlencode($mailbox);
	$s .= '&startMessage='.urlencode($startMessage);
	$s .= '&show_more='.urlencode($show_more);
	$s .= '&bayes_recache=1">Recalculate Score</a>';
	$s .= '</td>' . "\n";
	$s .= '</TR>';
	
	echo $s;
}

// Show the link to our own custom options page
function bayesspam_options() {
	global $optpage_blocks;
   
	$optpage_blocks[] = array(
		'name' => _("BayesSpam - Intelligent Spam Filtering"),
		'url' => '../plugins/bayesspam/options.php',
		'desc' => _("An intelligent mail filter that actually learns what you consider to be spam. Uses Bayesian filtering to very accurately filter out your spam."),
		'js' => false
	);
}

?>
