<?php
require_once('../functions/mailbox_display.php');
require_once('../plugins/bayesspam/config.php');

function bayesspam_filter($args) {
	global $mailbox, $username, $key, $imapServerAddress, $imapPort, $imap,
	$imap_general, $filters, $imap_stream, $imapConnection, $bayesspam_filtering_enabled,
	$UseSeparateImapConnection;

	if (!$bayesspam_filtering_enabled)
		return 0;

	// Detect if we have already connected to IMAP or not.
	// Also check if we are forced to use a separate IMAP connection
	if ((!isset($imap_stream) && !isset($imapConnection)) || $UseSeparateImapConnection) {
		$stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 10);
		$previously_connected = false;
	} elseif (isset($imapConnection)) {
		$stream = $imapConnection;
		$previously_connected = true;
	} else {
		$previously_connected = true;
		$stream = $imap_stream;
	}

	if($args[0] == 'left_main_before') {
		bayesspam_filters($stream);
	} else {
		bayesspam_filters_one($stream);
	}

	if (!$previously_connected) {
		sqimap_logout($stream);
	}
}

function bayesspam_filters(&$imap_stream) {
	global $data_dir, $username, $bayesspam_folder, $bayes_username, $bayesdbhandle, $bayesspam_folder, $bayesspam_delete, $bayesspam_autolearn, $bayesspam_ignore_folders, $version;

	$version_array = split('\.', $version);

	$corpus = bayesspam_get_corpus();
	
	$do_autolearn_spam = 0;
	$do_autolearn_nonspam = 0;
	$spam_occurences = array();
	$nonspam_occurences = array();
	$new_spam_occurences = array();
	$new_nonspam_occurences = array();
	if ($bayesspam_autolearn) {
		$spam_occurences = bayesspam_get_occurences('spam');
		$nonspam_occurences = bayesspam_get_occurences('nonspam');
	}

	$run_folders = array();
	$boxes = sqimap_mailbox_list($imap_stream);
	$sid = sqimap_session_id();

	foreach ($boxes as $box) {
		if (!in_array($box['unformatted-dm'],$bayesspam_ignore_folders)
				&& array_search('noselect',$box['flags']) === FALSE 
				&& !preg_match("/^INBOX\.Sent/",$box['unformatted-dm']) 
				&& sqimap_unseen_messages($imap_stream, $box['unformatted-dm']) > 0) {
					$run_folders[] = $box['unformatted-dm'];
		}
	}

	foreach ($run_folders as $box) {
		$spam_messages = array();
        $qty = sqimap_get_num_messages ($imap_stream, $box);
        $id = range(1, $qty);

		$mbxresponse = sqimap_mailbox_select($imap_stream, $box);

		$msgs_list = sqimap_get_small_header_list($imap_stream, $id, 0);

		$which = 0;
		$messages = array();
		if (sizeof($msgs_list)){
			foreach ($msgs_list as $hdr) {
				if ($hdr->flag_seen != TRUE) {
					$messages[] = $id[$which];
				}
				$which++;
			 }
		}

		foreach ($messages as $passed_id) {
			
			if ($bayesspam_autolearn) {
				// Do this stuff even though it's done in bayesspam_get_probability()
				// so that we can use the tokens for the autolearn
				$tokens = bayesspam_get_tokens($imap_stream, $passed_id);
			}
			
			$is_spam = bayesspam_get_probability($imap_stream, $passed_id);

			if ($is_spam>.9) {
				$spam_messages[] = $passed_id;
			}
			if ($bayesspam_autolearn && !bayesspam_check_messageid()) {
				$type = '';
				if ($is_spam > .9 ) {
					$type = 'spam';
				} else {
					$type = 'nonspam';
				}
				$added_spam = 0;
				$added_nonspam = 0;
				foreach ($tokens as $token) {
					if (strlen($token) > 0) {
						if ($is_spam > .9) {
							$added_spam = 1;
							@$new_spam_occurences['token'.$token]++;
						} else {
							$added_nonspam = 1;
							@$new_nonspam_occurences['token'.$token] += 2;
						}
					}
				}
				if ($added_nonspam) {
					$do_autolearn_nonspam++;
				}
				if ($added_spam) {
					$do_autolearn_spam++;
				}
				bayesspam_add_messageid($type);
			}	
		}

		if ($spam_messages) {
			$message_str = sqimap_message_list_squisher($spam_messages);
			if ($bayesspam_delete) {
				sqimap_run_command ($imap_stream, "STORE $message_str +FLAGS (\\Deleted)", true, $response, $message);
			} elseif (sqimap_mailbox_exists($imap_stream, $bayesspam_folder)) {
				sqimap_run_command ($imap_stream, "COPY $message_str \"$bayesspam_folder\"", true, $response, $message);
				sqimap_run_command ($imap_stream, "STORE $message_str +FLAGS (\\Deleted)", true, $response, $message);
			}
	
	    	sqimap_mailbox_expunge($imap_stream, $box);
		}
	}

	if ($bayesspam_autolearn && ($do_autolearn_spam || $do_autolearn_nonspam)) {
		if ($do_autolearn_spam) {
			bayesspam_do_learn('spam',$spam_occurences,$new_spam_occurences,$do_autolearn_spam,1);
		}
		
		if ($do_autolearn_nonspam) {
			bayesspam_do_learn('nonspam',$nonspam_occurences,$new_nonspam_occurences,$do_autolearn_nonspam,1);
		}
	}
}

function bayesspam_filters_one(&$imap_stream) {
	global $data_dir, $username, $bayesspam_folder, $bayes_username, $bayesdbhandle, $bayesspam_folder, $bayesspam_delete, $bayesspam_autolearn, $mailbox, $bayesspam_ignore_folders, $version;

	$version_array = split('\.', $version);

	$corpus = bayesspam_get_corpus();

	$do_autolearn_spam = 0;
	$do_autolearn_nonspam = 0;
	$spam_occurences = array();
	$nonspam_occurences = array();
	$new_spam_occurences = array();
	$new_nonspam_occurences = array();
	if ($bayesspam_autolearn) {
		$spam_occurences = bayesspam_get_occurences('spam');
		$nonspam_occurences = bayesspam_get_occurences('nonspam');
	}

	$run_folders = array();
	$boxes = sqimap_mailbox_list($imap_stream);
	$sid = sqimap_session_id();

	foreach ($boxes as $box) {
		if ($box['unformatted-dm'] == $mailbox && !in_array($box['unformatted-dm'],$bayesspam_ignore_folders)
				&& array_search('noselect',$box['flags']) === FALSE
				&& !preg_match("/^INBOX\.Sent/",$box['unformatted-dm']) 
				&& sqimap_unseen_messages($imap_stream, $box['unformatted-dm']) > 0) {
					$run_folders[] = $box['unformatted-dm'];
		}
	}

	foreach ($run_folders as $box) {
		$spam_messages=array();
        $qty = sqimap_get_num_messages ($imap_stream, $box);
        $id = range(1, $qty);

		$mbxresponse = sqimap_mailbox_select($imap_stream, $box);
		
		$msgs_list = sqimap_get_small_header_list($imap_stream, $id, 0);


		$which = 0;
		$messages = array();
		if (sizeof($msgs_list)){
			foreach ($msgs_list as $hdr) {
				if ($hdr->flag_seen != TRUE) {
					$messages[] = $id[$which];
				}
				$which++;
			 }
		}

		foreach ($messages as $passed_id) {
			
			if ($bayesspam_autolearn) {
				// Do this stuff even though it's done in bayesspam_get_probability()
				// so that we can use the tokens for the autolearn
				$tokens = bayesspam_get_tokens($imap_stream,$passed_id);
			}
			
			$is_spam = bayesspam_get_probability($imap_stream, $passed_id);

			if ($is_spam>.9) {
				$spam_messages[] = $passed_id;
			}
	
			if ($bayesspam_autolearn && !bayesspam_check_messageid()) {
				$type = '';
				if ($is_spam > .9 ) {
					$type = 'spam';
				} else {
					$type = 'nonspam';
				}
				$added_spam = 0;
				$added_nonspam = 0;
				foreach ($tokens as $token) {
					if (strlen($token) > 0) {
						if ($is_spam > .9) {
							$added_spam = 1;
							@$new_spam_occurences['token'.$token]++;
						} else {
							$added_nonspam = 1;
							@$new_nonspam_occurences['token'.$token] += 2;
						}
					}
				}
				if ($added_nonspam) {
					$do_autolearn_nonspam++;
				}
				if ($added_spam) {
					$do_autolearn_spam++;
				}
				bayesspam_add_messageid($type);
			}	
		}
		if ($spam_messages) {
	 		$message_str = sqimap_message_list_squisher($spam_messages);
			if ($bayesspam_delete) {
				sqimap_run_command ($imap_stream, "STORE $message_str +FLAGS (\\Deleted)", true, $response, $message);
			} elseif (sqimap_mailbox_exists($imap_stream, $bayesspam_folder)) {
				sqimap_run_command ($imap_stream, "COPY $message_str \"$bayesspam_folder\"", true, $response, $message);
				sqimap_run_command ($imap_stream, "STORE $message_str +FLAGS (\\Deleted)", true, $response, $message);
			}
		   	sqimap_mailbox_expunge($imap_stream, $box);
		}
	}

	if ($bayesspam_autolearn && ($do_autolearn_spam || $do_autolearn_nonspam)) {
		if ($do_autolearn_spam) {
			bayesspam_do_learn('spam',$spam_occurences,$new_spam_occurences,$do_autolearn_spam,1);
		}
		
		if ($do_autolearn_nonspam) {
			bayesspam_do_learn('nonspam',$nonspam_occurences,$new_nonspam_occurences,$do_autolearn_nonspam,1);
		}
	}
}

?>