<?php
/**
 * SquirrelMail AutoSubscribe Plugin
 * Sample config
 * Copyright (C) 2004-2006 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @version $Id: config_sample.php,v 1.4 2006/09/02 09:41:35 tokul Exp $
 * @package sm-plugins
 * @subpackage autosubscribe
 */

/**
 * Comma separated list of mailboxes that must be created
 * during login.
 * @global string $autosubscribe_folders
 */
$autosubscribe_folders='INBOX.info';

/**
 * Comma separated list of mailboxes that must be created
 * during login. These mailboxes are also marked as special
 * in SquirrelMail
 * @global string $autosubscribe_special_folders
 */
$autosubscribe_special_folders='INBOX.Spams,INBOX.Hams';

/**
 * Delay between two autosubscribe all calls
 *
 * This variable controls automatic subscription of all folders. If variable is
 * set to zero or negative number, automatic subscription of all folders is
 * disabled. If variable is greater than zero, plugin calculates difference 
 * between current timestamp and timestamp of the last update. If difference is
 * greater than this setting, plugin subscribes all unsubscribed folders. 
 * Variable sets difference in seconds.
 *
 * Please remember that subscription of all folders increases number of mailbox
 * listing calls and these calls can slow down interface. Set it to some sane 
 * value. 3600 value delays for one hour. 86400 delays subscription for one 
 * day. Subscription is performed in left_main.php and it will be executed once
 * user logs in or refreshes folder listing.
 *
 * If setting is set to 1, delay is not calculated. This setting value has 
 * special meaning. Plugin will only subscribe all folders, if user preferences
 * don't have autosubscribe tracker or tracker is set to 0.
 *
 * Default setting value disables automatic subscription. Last update timestamp
 * is stored in user preferences, autosubscribe_all_tracker setting. Default
 * setting value is equal to Unix epoch time (1970-01-01 00:00:00).
 * @global integer $autosubscribe_all_delay
 * @since 1.1
 */
$autosubscribe_all_delay = 0;
