<?php
/**
 * plugins/autosubscribe/setup.php -- Main setup script
 *
 * SquirrelMail AutoSubscribe Plugin
 * Copyright (C) 2004-2006 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @version $Id: setup.php,v 1.7 2006/09/02 09:41:35 tokul Exp $
 * @package sm-plugins
 * @subpackage autosubscribe
 */

/**
 * init function
 */
function squirrelmail_plugin_init_autosubscribe() {
  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['left_main_before']['autosubscribe'] = 'autosubscribe';
  $squirrelmail_plugin_hooks['special_mailbox']['autosubscribe'] = 'autosubscribe_special';
}

/**
 * Subscribes folders during login
 */
function autosubscribe() {
  include_once(SM_PATH . 'plugins/autosubscribe/functions.php');
  autosubscribe_function();
}

/**
 * Marks folders as special
 */
function autosubscribe_special($mb) {
  include_once(SM_PATH . 'plugins/autosubscribe/functions.php');
  return autosubscribe_special_function($mb);
}

/**
 * shows plugin's version
 * @return string
 */
function autosubscribe_version() {
  return '1.1';
}
