<?php
/**
 * plugins/autosubscribe/functions.php -- Functions used by plugin
 *
 * SquirrelMail AutoSubscribe Plugin
 * Copyright (C) 2004-2006 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @version $Id: functions.php,v 1.9 2006/09/02 09:41:35 tokul Exp $
 * @package sm-plugins
 * @subpackage autosubscribe
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/** include SM IMAP functions */
include_once(SM_PATH . 'functions/imap_general.php');
include_once(SM_PATH . 'functions/imap_mailbox.php');

/** load defaults */
global $autosubscribe_folders, $autosubscribe_special_folders,$autosubscribe_all_delay; 
$autosubscribe_folders='';
$autosubscribe_special_folders='';
$autosubscribe_all_delay=0;

// load config
if (file_exists(SM_PATH . 'config/autosubscribe_config.php')) {
    include_once(SM_PATH . 'config/autosubscribe_config.php');
} elseif (file_exists(SM_PATH . 'plugins/autosubscribe/config.php')) {
    include_once(SM_PATH . 'plugins/autosubscribe/config.php');
}

/**
 * Subscribes to folders during login
 * (internal function)
 */
function  autosubscribe_function() {
    global $autosubscribe_folders, $autosubscribe_special_folders, $autosubscribe_all_delay;

    global $imapServerAddress, $imapPort, $delimiter, $data_dir;

    sqgetGlobalVar('username', $username, SQ_SESSION);
    sqgetGlobalVar('key', $key, SQ_COOKIE);

    // combine list of folders into one string.
    $mbox_list=array();
    if ($autosubscribe_folders!='') {
        foreach(explode(',',$autosubscribe_folders) as $folder) {
            // add all folders to array and strip whitespace from 
            // beginning and end of name.
            $mbox_list[]=trim($folder);
        }
    }

    if ($autosubscribe_special_folders!='') {
        foreach(explode(',',$autosubscribe_special_folders) as $folder) {
            // add all folders to array and strip whitespace from 
            // beginning and end of name.
            $mbox_list[]=trim($folder);
        }
    }

    $autosubscribe_all = false;
    if ($autosubscribe_all_delay > 0) {
        $autosubscribe_all_tracker = getPref($data_dir,$username,'autosubscribe_all_tracker',0);
        if ($autosubscribe_all_delay === 1) {
            // subscribe only once option
            if ($autosubscribe_all_tracker == 0) {
                $autosubscribe_all = true;
            }
        } elseif (time() - $autosubscribe_all_delay > $autosubscribe_all_tracker) {
            // subscribe with delay option
            $autosubscribe_all = true;
        }
    }

    if (! empty($mbox_list) || $autosubscribe_all) {
        // open imap connection
        $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
    }

    if (! empty($mbox_list)) {
        foreach ($mbox_list as $mbox) {
            // If mailbox ends with delimiter, remove it from mailbox name
            // and set mailbox type to 'noselect'
            if (substr($mbox,-1)==$delimiter) {
                $mbox_type = 'noselect';
                $mbox = substr($mbox,0,strlen($mbox)-1);
            } else {
                $mbox_type = '';
            }
            if (! sqimap_mailbox_is_subscribed($imapConnection,$mbox)) {
                if(! sqimap_mailbox_exists($imapConnection,$mbox)) {
                    sqimap_mailbox_create($imapConnection,$mbox,$mbox_type);
                } else {
                    sqimap_subscribe($imapConnection,$mbox);
                }
            }
        }
    }

    if ($autosubscribe_all) {
        // get uncached mailbox listing
        $subscribed = sqimap_mailbox_list($imapConnection,true);
        // remove unneeded data from mailboxes array
        $packed_subscribed = autosubscribe_pack_mailboxes($subscribed);
        // get all mailboxes
        $all = sqimap_mailbox_list_all($imapConnection);
        // remove unneeded data
        $packed_all = autosubscribe_pack_mailboxes($all);
        // calculate difference between arrays
        $unsubscribed = array_diff($packed_all,$packed_subscribed);
        // subscribe all unsubscribe boxes
        foreach($unsubscribed as $mbox) {
            sqimap_subscribe($imapConnection,$mbox);
        }
        // update tracker
        setPref($data_dir,$username,'autosubscribe_all_tracker',time());
    }

    if (! empty($mbox_list) || ($autosubscribe_all && count($unsubscribed) > 0)) {
        // force rebuild of mailbox listing
        sqimap_mailbox_list($imapConnection,true);
    }

    if (! empty($mbox_list) || $autosubscribe_all) {
        // close imap connection
        sqimap_logout($imapConnection);
    }
}

/**
 * Marks autosubscribed folders as special
 * @param string $mb folder name
 * @return boolean true, if folder is special
 */
function autosubscribe_special_function($mb) {
    global $autosubscribe_special_folders;
    if ($autosubscribe_special_folders=='') return false;
    return (in_array($mb,explode(',',$autosubscribe_special_folders)));
}

/**
 * @param array standard sqimap mailbox array. See sqimap_mailbox_parse() 
 * documentation.
 * @return array indexed array with real mailbox names
 * @since 1.1
 */
function autosubscribe_pack_mailboxes($mailboxes) {
    $ret = array();
    foreach ($mailboxes as $mailbox_data) {
        array_push($ret,$mailbox_data['unformatted']);
    }
    return $ret;
}
