<?php
/**
 * plugins/autosubscribe/functions.php -- Functions used by plugin
 *
 * SquirrelMail AutoSubscribe Plugin
 * Copyright (C) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This program is licensed under GPL. See COPYING for details
 *
 * @version $Id: functions.php,v 1.5 2005/03/20 09:59:08 tokul Exp $
 * @package sm-plugins
 * @subpackage autosubscribe
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/** include SM functions */
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/imap.php');

/** load defaults */
global $autosubscribe_folders, $autosubscribe_special_folders; 
$autosubscribe_folders='';
$autosubscribe_special_folders='';

// load config
if (file_exists(SM_PATH . 'config/autosubscribe_config.php')) {
    include_once(SM_PATH . 'config/autosubscribe_config.php');
} elseif (file_exists(SM_PATH . 'plugins/autosubscribe/config.php')) {
    include_once(SM_PATH . 'plugins/autosubscribe/config.php');
}

/**
 * Subscribes to folders during login
 * (internal function)
 */
function  autosubscribe_function() {
    global $autosubscribe_folders, $autosubscribe_special_folders;

    global $imapServerAddress, $imapPort, $delimiter;

    sqgetGlobalVar('username', $username, SQ_SESSION);
    sqgetGlobalVar('key', $key, SQ_COOKIE);

    // combine list of folders into one string.
    $mbox_list=array();
    if ($autosubscribe_folders!='') {
        foreach(explode(',',$autosubscribe_folders) as $folder) {
            // add all folders to array and strip whitespace from 
            // beginning and end of name.
            $mbox_list[].=trim($folder);
        }
    }

    if ($autosubscribe_special_folders!='') {
        foreach(explode(',',$autosubscribe_special_folders) as $folder) {
            // add all folders to array and strip whitespace from 
            // beginning and end of name.
            $mbox_list[].=trim($folder);
        }
    }

    if (! empty($mbox_list)) {
        // open imap connection
        $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);

        foreach ($mbox_list as $mbox) {
            if (! sqimap_mailbox_is_subscribed($imapConnection,$mbox)) {
                if(! sqimap_mailbox_exists($imapConnection,$mbox)) {
                    sqimap_mailbox_create($imapConnection,$mbox,'select');
                } elseif (substr($mbox,-1)!=$delimiter) {
                    // Subscribe to folder only when name does not end with delimiter.
		    // folder is not /noselect mailbox.
		    // squirrelmail reports /noselect mailboxes as not subscribed
                    sqimap_subscribe($imapConnection,$mbox);
                }
            }
        }

        // force rebuild of mailbox listing
        sqimap_mailbox_list($imapConnection,true);

        // close imap connection
        sqimap_logout($imapConnection);
    }
}

/**
 * Marks autosubscribed folders as special
 * @param string $mb folder name
 * @return boolean true, if folder is special
 */
function autosubscribe_special_function($mb) {
    global $autosubscribe_special_folders;
    if ($autosubscribe_special_folders=='') return false;
    return (in_array($mb,explode(',',$autosubscribe_special_folders)));
}
?>