<?php
/*
 * autorespond:  $Id: setup.php,v 1.6 2007/09/05 23:18:09 shaug Exp $
 * (c) 2002 O'Shaughnessy Evans <shaug-sqmail @ wumpus.org>
 * 
 * Let a user change their email forwarding and vacation files
 */

if (!defined('SM_PATH'))
    define('SM_PATH', '../../');

/* Initialize the plugin */
function squirrelmail_plugin_init_autorespond()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['optpage_register_block']['autorespond']
     = 'autorespond_options';
    $squirrelmail_plugin_hooks['menuline']['autorespond']
     = 'autorespond_menuline';
}

function autorespond_options()
{
    global $optpage_blocks;

    bindtextdomain('autorespond', SM_PATH. 'plugins/autorespond/locale');
    textdomain('autorespond');

    $optpage_blocks[] = array(
        'name' => _('Auto Response:  Reply or Forward'),
        'url'  => '../plugins/autorespond/options.php',
        'desc' => _('Automatically reply to incoming mail or send '.
                  'it all to another address.'),
        'js'   => FALSE
    );

    bindtextdomain('squirrelmail', SM_PATH. 'locale');
    textdomain('squirrelmail');
}

function autorespond_menuline()
{
    bindtextdomain('autorespond', SM_PATH. 'plugins/autorespond/locale');
    textdomain('autorespond');

    displayInternalLink('plugins/autorespond/options.php',
                        _('Auto Response'),
                        '');
    echo '&nbsp;&nbsp;';

    bindtextdomain('squirrelmail', SM_PATH. 'locale');
    textdomain('squirrelmail');
}

?>
