<?php
/**
 * Auto Prune Sent Folder Plugin
 *
 * This plugin automatically cleans out messages from your Sent folder
 * which are older than a (user-settable) certain age.
 * Plugin designed for use with SquirrelMail 1.3.3 or newer.
 * May work with SquirrelMail 1.2.x, but no guarantees as I don't use 1.2. Sorry.
 * 
 * Chris Hilts <chilts@birdbrained.org> - 11 December 2002
 *
 */

/* default_prune_threshold sets the minimum age (in days) that messages
   must be before they will be automatically pruned.  This is settable
   by each user under "folder options" in SquirrelMail.  To avoid
   potential unexpected data loss (messages suddenly disappearing) after
   this plugin is installed, the default is 0.  If you don't want to make
   each user need to turn this on, you can set the default here.

   NOTE: If you set this and one of your users has a year's worth of junk
   in Sent that they want to keep, be prepared for the complaints... */

$default_prune_threshold = 0;

/* DO NOT EDIT BELOW THIS LINE */

function squirrelmail_plugin_init_auto_prune_sent() {
	global $squirrelmail_plugin_hooks;
	$squirrelmail_plugin_hooks['left_main_before']['auto_prune_sent'] = 'auto_prune_sent_start';
	$squirrelmail_plugin_hooks['options_folder_inside']['auto_prune_sent'] = 'auto_prune_sent_options_edit';
	$squirrelmail_plugin_hooks['options_folder_save']['auto_prune_sent'] = 'auto_prune_sent_options_save';
	$squirrelmail_plugin_hooks['loading_prefs']['auto_prune_sent'] = 'auto_prune_sent_options_load';

}
function auto_prune_sent_version() {
	return "Auto-Prune Sent V1.1";
}

function auto_prune_sent_start() {
	include_once SM_PATH . 'plugins/auto_prune_sent/startup.php';
}

function auto_prune_sent_options_edit() {
	include_once SM_PATH . 'plugins/auto_prune_sent/options.php';
	auto_prune_sent_options_edit_real();
}

function auto_prune_sent_options_load() {
	include_once SM_PATH . 'plugins/auto_prune_sent/options.php';
	auto_prune_sent_options_load_real();
}

function auto_prune_sent_options_save() {
	include_once SM_PATH . 'plugins/auto_prune_sent/options.php';
	auto_prune_sent_options_save_real();
}

?>
