<?php

/* 
 * tnef.php
 *  Graham Norbury <gnorbury@bondcar.com>
 *  (c) 2002 (GNU GPL - see ../../COPYING)
 *
 *  Displays table of contents and handles attachment download for ms-tnef files
 *
 */

   chdir("..");

   include_once('../src/validate.php');
   include_once("../functions/date.php");
   include_once("../functions/page_header.php");
   include_once("../functions/mime.php");
   include_once("../src/load_prefs.php");

   include_once("../plugins/attachment_tnef/tnef_decoder.php");
   include_once("../plugins/attachment_tnef/download_fn.php");

   header("Pragma: ");
   header("Cache-Control: cache");

   global $debug, $download;
   $debug = 0; // change this to 1 to enable debugging output

   $download = (!isset($file_id)) ? 0 : 1;  // only display page if not downloading
   $debug = ((!$download) && $debug);       // debugging disabled when downloading
   session_register('download');
   session_register('debug');

   // extract the tnef attachment and decode it
   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   sqimap_mailbox_select($imapConnection, $mailbox);
   $message = sqimap_get_message($imapConnection, $passed_id, $mailbox);
   $entity_tnef = getEntity($message,$passed_ent_id);

   $filename = decodeHeader($entity_tnef->header->filename);
   if (!$filename)
   {
      $filename = decodeHeader($header->name);
   }

   $tnef = mime_fetch_body ($imapConnection, $passed_id, $passed_ent_id); 
   $tnef = decodeBody($tnef, $entity_tnef->header->encoding);
   $tnef_files = tnef_decode($tnef);

   if (!$download)  // only display page if not downloading
   {
      displayPageHeader($color, "None");

?>
<br>
<table width="100%" border="0" cellspacing="0" cellpadding="2" align="center">
 <tr>
  <td bgcolor="<?php echo $color[0]; ?>">
   <b><center>
<?php

      echo _("Viewing $filename") . " - ";
      if (isset($where) && isset($what))
      {
         // from a search
         echo "<a href=\"../../src/read_body.php?mailbox=" . urlencode($mailbox) .
              "&passed_id=$passed_id&where=" . urlencode($where) .
              "&what=".urlencode($what) . "\">" . _("View message") . "</a>";
      }
      else
      {   
         echo "<a href=\"../../src/read_body.php?mailbox=" . urlencode($mailbox) .
              "&passed_id=$passed_id&startMessage=$startMessage&show_more=0\">" .
              _("View message") . "</a>";
      }   
      echo "</center></b></td></tr></table>";

      // IMHO the following html is very difficult to interpret...
      // For consistency with the way other attachments are displayed
      // this is more or less a straight copy from mime.php
      $body = "<TABLE WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=2 " .
              "BORDER=0 BGCOLOR=\"$color[0]\"><TR>\n" .
              "<TH ALIGN=\"left\" BGCOLOR=\"$color[9]\"><B>\n" .
              _("$filename attachments") . ':' .  "</B></TH></TR><TR><TD>\n" .
              "<TABLE CELLSPACING=0 CELLPADDING=1 BORDER=0>\n";

      $file_count = sizeof($tnef_files);
      for ($id = 0; $id < $file_count; $id++)
      {
         $dl_href = 'tnef.php?' . $HTTP_SERVER_VARS['QUERY_STRING'] . "&file_id=$id";
         $body .= '<TR><TD>&nbsp;&nbsp;</TD><TD>' .
                  "<A HREF=\"$dl_href\">" . $tnef_files[$id]['name'] . "</A>&nbsp;</TD>" .
                  '<TD><SMALL><b>' . show_readable_size($tnef_files[$id]['size']) .
                  '</b>&nbsp;&nbsp;</small></TD>' .
                  sprintf("<TD><SMALL>[ %s/%s ]&nbsp;</SMALL></TD>",
                          $tnef_files[$id]['type0'],
                          $tnef_files[$id]['type1']) .
                  '<TD><SMALL></SMALL></TD><TD><SMALL>&nbsp;' .
                  "<A HREF=\"$dl_href&absolute_dl=1\">download</A>" .
                  "</SMALL></TD></TR>\n";
      }

      $body .= "</TABLE></TD></TR></TABLE>";

      echo($body);

?>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER>
<TR><TD BGCOLOR="<?PHP echo $color[4] ?>">
</TD></TR></TABLE>
</body></html>
<?PHP

   }
   else //download the requested attachment
   {
      set_time_limit(0); // disable 30 second timer in case download takes a while

      DumpHeaders($tnef_files[$file_id]['type0'],
                  $tnef_files[$file_id]['type1'],
                  $tnef_files[$file_id]['name'],
                  $tnef_files[$file_id]['size'],
                  $absolute_dl);

      echo($tnef_files[$file_id]['stream']);
   }

?>
