<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Archive Mail
    Version ........ 0.6
    Purpose ........ Allows you to download your email in a zip

*******************************************************************************/

if (@!function_exists('gzcompress')) {
   print "Your PHP does not have zlib installed (function gzcompress does not exist)";
   exit;
}

chdir("..");
if (!defined('SM_PATH'))
   define('SM_PATH','../');

if (file_exists(SM_PATH . 'include/validate.php')) {
   include_once(SM_PATH . 'include/validate.php');
} else {
   if (file_exists(SM_PATH . 'src/validate.php'))
      include_once(SM_PATH . 'src/validate.php');
}

require_once(SM_PATH . 'functions/mime.php');
require_once(SM_PATH . 'functions/date.php');
require_once('zip.php');

if (isset($_SESSION['username']) && !isset($username))
   $username = $_SESSION['username'];
if (isset($_SESSION['data_dir']) && !isset($data_dir))
   $data_dir = $_SESSION['data_dir'];
if (isset($_COOKIE['key']) && !isset($key))
   $key  = $_COOKIE['key'];
if (isset($_GET['mailbox']) && !isset($mailbox))
   $mailbox = $_GET['mailbox'];
if (isset($_SESSION['onetimepad']) && !isset($onetimepad))
   $onetimepad = $_SESSION['onetimepad'];

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   
if ($imapConnection) {
    // Don't kill the connection if the browser is over a dialup
    // and it would take over 30 seconds to download it.
    // don t call set_time_limit in safe mode.
    if (!ini_get("safe_mode"))
        set_time_limit(0);

   $hashed_dir = getHashedFile($username, $data_dir, '$username.pref');
   $archivefilenames = getPref($hashed_dir, $username, 'archivefilenames');
   $archiveattachments = getPref($hashed_dir, $username, 'archiveattachments');
   $mailbox = urldecode(urldecode($mailbox));
   sqimap_mailbox_select($imapConnection, $mailbox);
   $numMessages = sqimap_get_num_messages($imapConnection, $mailbox);
   if ($numMessages == 0)
       exit;

   $filename = archive_replace_str($mailbox, '-');
   sendheader($filename);

   // Creat a new zipfile
   $zipfile = new zipfile();
   $names = array();
   global $names;
   for ($a = 1; $a < $numMessages+1; $a++) {
/*
 * $message contains all information about the message
 * including header and body
 */
      $message2 = sqimap_get_message($imapConnection, $a, $mailbox);

      if (function_exists('sqgetGlobalVar')) {
         $date = decodeHeader($message2->rfc822_header->date);
         $date = date('m-j-y', $date);
         $email2 = decodeHeader($message2->rfc822_header->getAddr_s('from'));
         $email = archive_replace_str(archive_find_email($email2));
         $subject2 = decodeHeader($message2->rfc822_header->subject);
         $subject = archive_replace_str($subject2);
         if ($subject == '')
            $subject = 'No Subject';
         $to = decodeHeader($message2->rfc822_header->getAddr_s('to'));
      } else {
         $date = decodeHeader($message2->header->date);
         $date = date('m-j-y', $date);
         $email2 = decodeHeader($message2->header->from);
         $email = archive_replace_str(archive_find_email($email2));
         $subject2 = decodeHeader($message2->header->subject);
         $subject = archive_replace_str($subject2);
         if ($subject == '')
            $subject = 'No Subject';
         $to = decodeHeader(getLineOfAddrs($message2->header->to));
      }
      $count = count($message2->entities);
      if ($count == 0)
         $count = 1;

      for ($b = 1; $b < $count + 1; $b++) {
         $filename = '';
         if (function_exists('sqgetGlobalVar')) {
            $message = $message2->getEntity($b);
            $header = $message->rfc822_header;
            $body = mime_fetch_body ($imapConnection, $a, $b);
            $body = decodeBody($body, $message->header->encoding);
            $filename = $message->header->getParameter('filename');
            if (!$filename)
               $filename = $message->header->getParameter('name');
            $type0 = $message->type0;
            $type1 = $message->type1;
         } else {
            $message = getEntity($message2, $b);
            $header = $message->header;
            $type0 = $header->type0;
            $type1 = $header->type1;
            $filename = decodeHeader($header->filename);
            if (!$filename)
               $filename = decodeHeader($header->name);
            $body = mime_fetch_body ($imapConnection, $a, $b);
            $body = decodeBody($body, $header->encoding);
         }
         if (isset($override_type0))
            $type0 = $override_type0;
         if (isset($override_type1))
            $type1 = $override_type1;
         if ($filename && $archiveattachments == 0) {
            // We don't want to download attachments
         }else{
            $isattachment = false;
            $filename = archive_replace_str($filename);
            if ($filename)
               $isattachment = true;
            if (strlen($filename) < 1) {
               if ($type1 == 'plain' && $type0 == 'text') {
                  $suffix = '.txt';
               } else if ($type1 == 'richtext' && $type0 == 'text') {
                  $suffix = '.rtf';
               } else if ($type1 == 'postscript' && $type0 == 'application') {
                  $suffix = '.ps';
               } else if ($type1 == 'rfc822' && $type0 == 'message') {
                  $suffix = '.eml';
               } else {
                  if ($type1 != '')
                     $suffix = ".$type1";
                  else
                     $suffix = '';
               }

               if ($filename == '') {
                  if ($archivefilenames < 1)
                     $archivefilenames = 0;
                  $temp = '';
                  switch ($archivefilenames) {
                     case 0:     // Numbers
                        $temp = $a;
                        break;
                     case 1:     // Date
                        $temp = $date;
                        break;
                     case 2:     // Date - Email
                        $temp = $date . ' - ' . $email;
                        break;
                     case 3:     // Email
                        $temp = $email;
                        break;
                     case 4:     // Email - Date
                        $temp = $email . ' - ' . $date;
                        break;
                     case 5:     // Subject
                        $temp = $subject;
                        break;
                     case 6:     // Email - Subject
                        $temp = $email . " - ($subject)";
                        break;
                     case 7:     // Date - Subject
                        $temp = $date . " - ($subject)";
                        break;
                     case 8:     // Subject - Email
                        $temp = "($subject) - " . $email;
                        break;
                     case 9:     // Subject - Date
                        $temp = "($subject) - " . $date;
                        break;
                     default:
                        break;
                  }
                  $increment = checkincrement($temp . $suffix);
                  $filename = $temp . $increment;
               }
               $filename = $filename . $suffix;
            }
            $temp = '';
            if (!$isattachment && ($type0 == 'text' || ($type0 == '' && $type1 == ''))) {
                  if ($type1 == 'plain' || $type1 == '') {
                  $temp = _("Subject") . ": $subject2\n" .
                     '   ' . _("From") . ": $email2\n" .
                     '     ' . _("To") . ": $to\n" .
                     '   ' . _("Date") . ": $date\n\n";
               } elseif ($type1 == 'html') {
                  $temp = "<table><tr><th align=right>" . _("Subject").
                      ":</th><td>$subject2" .
                      "</td></tr>\n<tr><th align=right>" . _("From").
                      ":</th><td>$email2" .
                      "</td></tr>\n<tr><th align=right>" . _("To").
                      ":</th><td>$to" .
                      "</td></tr>\n<tr><th align=right>" . _("Date").
                      ":</th><td>$date" .
                      "</td></tr>\n</table>\n<hr>\n";
               }
            }
            $temp = $temp . $body;
            $zipfile -> addFile($temp, $filename);
         }
      }
   }
   header("Content-Length: ".strlen($zipfile -> file()));
   echo $zipfile -> file();
}

function archive_find_email($str) {
   $IP_RegExp_Match = '\\[?[0-9]{1,3}(\\.[0-9]{1,3}){3}\\]?';
   $Host_RegExp_Match = '(' . $IP_RegExp_Match . '|[0-9a-z]([-.]?[0-9a-z])*\\.[a-z][a-z]+)';
   $Email_RegExp_Match = '[0-9a-z]([-_.+|]?[_0-9a-z|])*(%' . $Host_RegExp_Match . ')?@' . $Host_RegExp_Match;
   while (eregi('(' . $Email_RegExp_Match . ')', $str, $hits)) {
      $str = substr(strstr($str, $hits[0]), strlen($hits[0]));
      return $hits[0];
   }
   return;
}

function archive_replace_str($temp, $temp2 = ' ') {
   $temp = str_replace(chr(92), $temp2, $temp);
   $temp = str_replace('/', $temp2, $temp);
   $temp = str_replace(':', $temp2, $temp);
   $temp = str_replace('>', $temp2, $temp);
   $temp = str_replace('<', $temp2, $temp);
   $temp = str_replace('|', $temp2, $temp);
   $temp = str_replace('?', $temp2, $temp);
   $temp = str_replace('*', $temp2, $temp);
   $temp = str_replace(chr(34), $temp2, $temp);
   return $temp;
}

function checkincrement($tempsuffix) {
   global $names;
   if (isset($names[$tempsuffix])) {
      $names[$tempsuffix] = $names[$tempsuffix] + 1;
      $increment = $names[$tempsuffix];
      $increment = ' - ' . $increment;
   } else {
      $names[$tempsuffix] = 1;
      $increment = '';
   }
   return $increment;
}

?>