#!/usr/local/bin/php
<?php
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @author Jared Watkins 2003 <jared@watkins.net>
 * @package amavisnewsql
 * $Id: cleanquarantine.php, v
 *
 * This script should be called once a day from cron.  It will scan through
 * your quarantine database and remove anything that is old enough to be
 * aged out. These ages are set by each user.
 *
 * TODO: Make it do something more useful than just delete known spam
 *       maybe feed them into a shared bayes database or DCC?
 *
 * Change this to point to the amavisnewsql plugin directory
 * or whereever else you are storing this config file
 *
 * Be sure to include a trailing slash
 *
*/

DEFINE ("BASEINCLUDE", "/htdocs/squirrel/plugins/amavisnewsql/");




// You should not have to change anything below this line
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

include(BASEINCLUDE."config.php");
include(BASEINCLUDE."amavisnewsql.class.php");

$dbfp = new AmavisNewSQL();
$dbfp->connect();

   $now = time();
   $secondsperday = 86400;

   $q = "select $dbfp->msg_table.id, $dbfp->msg_table.storetime, $dbfp->users_table.retention, $dbfp->users_table.username
         from $dbfp->msg_table, $dbfp->users_table, $dbfp->msgowner_table
         where ('$now' - $dbfp->msg_table.storetime) > ($dbfp->users_table.retention * $secondsperday)
         and $dbfp->msgowner_table.rid = $dbfp->users_table.id
         and $dbfp->msgowner_table.msgid = $dbfp->msg_table.id";


   if (!$res = $dbfp->sqlRead($q, __FILE__, __LINE__)) {
       die ("cleanQuarantine Searching for Old Messages Error: $dberr");
   }

   for($i=0; $i < $res->numRows(); $i++) {
       $row = $res->fetchRow(DB_FETCHMODE_ASSOC);

       $q1 = "delete from $dbfp->msg_table where id = '$row[id]'";
       $res1 = $dbfp->sqlWrite($q1, __FILE__, __LINE__);

       $q2 = "delete from $dbfp->msgowner_table where msgid = '$row[id]'";
       $res2 = $dbfp->sqlWrite($q2, __FILE__, __LINE__);

       if ($res1 == FALSE || $res2 == FALSE) {
           $dbfp->sqlWrite("rollback", __FILE__, __LINE__);
           $dbfp->disconnect();
           die("cleanQuarantine Deleting Old Messages Error: $dberr");
       }

         else $dbfp->sqlWrite("commit", __FILE__, __LINE__);
   }


?>
