<?php
/**
 * Advanced Settings plugin functions
 *
 * Copyright (C) 2006 The SquirrelMail Project Team
 * This program is licensed under GPL. See COPYING for details
 * @author Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: functions.php,v 1.1 2006/04/14 18:48:59 tokul Exp $
 * @package sm-plugins
 * @subpackage advanced_settings
 */

/**
 * Main function that sets optpage data
 */
function advset_optpage_set_loadinfo_do() {
    /**
     * optpage_set_loadinfo hook calls attached plugins. Load plugin code
     * only when call is related to advanced_settings plugin
     */
    if (sqgetGlobalVar('optpage',$optpage,SQ_FORM) && 
        $optpage == 'advanced_settings') {

        bindtextdomain('advanced_settings',SM_PATH . 'locale');
        textdomain('advanced_settings');

        global $optpage_name, $optpage_file, $optpage_loader, $optpage_loadhook;
        $optpage_name = _("Advanced Settings");
        $optpage_file = SM_PATH . 'plugins/advanced_settings/options.php';
        $optpage_loader = 'load_optpage_advanced_settings';
        $optpage_loadhook = 'optpage_loadhook_advanced_settings';

        bindtextdomain('squirrelmail',SM_PATH . 'locale');
        textdomain('squirrelmail');
    }
}

/**
 * Main function that registers option block
 */
function advset_optpage_register_block_do() {
    global $optpage_blocks;

    bindtextdomain('advanced_settings',SM_PATH . 'locale');
    textdomain('advanced_settings');

    $optpage_blocks[] = array(
        'name' => _("Advanced Settings"),
        'url'  => 'options.php?optpage=advanced_settings',
        'desc' => _("You can control advanced interface options here."),
        'js'   => false
    );

    bindtextdomain('squirrelmail',SM_PATH . 'locale');
    textdomain('squirrelmail');
}

/**
 * Main function that loads preferences
 */
function advset_loading_prefs_do() {
    global $username, $data_dir, $auto_expunge, $use_special_folder_color, 
        $list_special_folders_first, $default_use_priority;

    /* boolean options */
    $auto_expunge = (bool) getPref($username, $data_dir, 'auto_expunge', $auto_expunge);
    $use_special_folder_color = (bool) getPref($username, $data_dir, 'use_special_folder_color', $use_special_folder_color);
    $list_special_folders_first = (bool) getPref($username, $data_dir, 'list_special_folders_first', $list_special_folders_first);
    $default_use_priority = (bool) getPref($username, $data_dir, 'default_use_priority', $default_use_priority);
}
?>