<?php

/**
  * SquirrelMail Add Header Plugin
  * Copyright (c) 2001-2003 Pontus Ullgren
  * Copyright (c) 2010 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage add_header
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_add_header()
{

   global $squirrelmail_plugin_hooks;


   // add custom headers to outgoing message
   //
   $squirrelmail_plugin_hooks['compose_send']['add_header']
      = 'add_custom_headers_stub';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['add_header']
      = 'add_header_check_configuration_stub';

}



/**
  * Returns info about this plugin
  *
  */
function add_header_info()
{

   return array(
                 'english_name' => 'Add Header',
                 'authors' => array(
                    'Pontus Ullgren' => array(
                    ),
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.2',
                 'requires_configuration' => 1,
                 'requires_source_patch' => 0,
                 'summary' => 'Allows the system administrator to add custom headers to outgoing messages.',
                 'details' => 'This plugin allows the system administrator to add custom headers to all outgoing messages sent from SquirrelMail (but, of course, not other mail clients).',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function add_header_version()
{
   $info = add_header_info();
   return $info['version'];
}



/**
  * Add custom headers to outgoing message
  *
  */
function add_custom_headers_stub(&$args)
{
   include_once(SM_PATH . 'plugins/add_header/functions.php');
   return add_custom_headers($args);
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function add_header_check_configuration_stub()
{
   include_once(SM_PATH . 'plugins/add_header/functions.php');
   return add_header_check_configuration();
}



