<?php

/**
  * SquirrelMail Add Header Plugin
  * Copyright (c) 2001-2003 Pontus Ullgren
  * Copyright (c) 2010 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage add_header
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function add_header_init()
{

   if (!@include_once (SM_PATH . 'config/config_add_header.php'))
      if (!@include_once (SM_PATH . 'plugins/add_header/config.php'))
         return FALSE;

   return TRUE;

}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function add_header_check_configuration()
{

   // make sure base config is available
   //
   if (!add_header_init())
   {
      do_err('Add Header plugin is missing its main configuration file', FALSE);
      return TRUE;
   }


   // done - nothing is wrong
   //
   return FALSE;

}



/**
  * Add custom headers to outgoing message
  *
  */
function add_custom_headers(&$args)
{

   global $custom_headers;


   // load config
   //
   add_header_init();


   // grab message object
   //
   if (check_sm_version(1, 5, 2))
      $message = &$args;
   else
      $message = &$args[1];


   // add headers
   //
   foreach ($custom_headers as $header_name => $header_value)
      $message->rfc822_header->more_headers[$header_name] = $header_value;


   // return modified message
   //
   return $message;

}



