<?php
/**
 * functions.php - Addressbook Import-Export functions
 *
 * Copyright (c) 1999-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Uses standard plugin format to create a couple of forms to
 * enable import/export of CSV files to/from the address book.
 * @version $Id: functions.php,v 1.8 2005/03/25 14:08:53 tokul Exp $
 * @package sm-plugins
 * @subpackage abook_import_export
 */

/** @ignore */
if (!defined('SM_PATH')) define('SM_PATH','../../');

/** load sqm_baseuri() function */
include_once(SM_PATH . 'functions/display_messages.php');

/** set configuration globals */
global $aie_csv_maxsize;

/** load default configuration*/
if (file_exists(SM_PATH . 'plugins/abook_import_export/config_default.php')) {
    include_once(SM_PATH . 'plugins/abook_import_export/config_default.php');
} else {
    // set default config values inside script, if file is removed.
    $aie_csv_maxsize=5120;
}

/** site configuration */
if (file_exists(SM_PATH . 'config/abook_import_export_config.php')) {
    include_once(SM_PATH . 'config/abook_import_export_config.php');
} elseif (file_exists(SM_PATH . 'plugins/abook_import_export/config.php')) {
    include_once(SM_PATH . 'plugins/abook_import_export/config.php');
}

/**
 * Displays plugin's version number
 * (internal function)
 * @return string version number
 */
function aie_version() {
    return '0.9';
}

/**
 * Add import/export form
 * (internal function)
 */
function aie_create_form() {
    global $color,$aie_csv_maxsize;

    // switch domain
    bindtextdomain('abook_import_export',SM_PATH . 'locale');
    textdomain('abook_import_export');

    // using php for html generation, because formating of mixed php/html code is not good.
    echo "<center>\n";
    echo '<table bgcolor="' . $color[0] 
        .'" width="90%" border="0" cellpadding="1" cellspacing="0" align="center">' . "\n";

    echo "<tr>\n";
    echo "<!-- ----------------- begin csv import form --------------------- -->\n";
    // don't use MAX_FILE_SIZE input field or don't rely on it.
    // Size can't be controlled in place that can be modified by end user.
    echo '<form enctype="multipart/form-data" action="'
        .sqm_baseuri() . 'plugins/abook_import_export/address_book_import.php'
        .'" method="post">' . "\n";
    echo html_tag('td',_("Import Address Book:"),'right','','valign="middle"')
        .html_tag('td','<input name="smusercsv" type="file">'
                  .'&nbsp;'._("Max: ") . aie_display_size($aie_csv_maxsize).'&nbsp;'
                  .'<input type="submit" value="'._("Import CSV File").'">','left');
    echo "</form>\n";
    echo "<!-- ----------------- end csv import form  ---------------------- -->\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<!-- ----------------- begin csv export form --------------------- -->\n";
    echo '<form ENCTYPE="multipart/form-data" action="'
        .sqm_baseuri() . 'plugins/abook_import_export/address_book_export.php'
        .'" method="post">';
    echo html_tag('td',_("Export Address Book:"),'right','','valign="middle"');
    echo html_tag('td','<input type="submit" value="' 
                  ._("Export to CSV File") 
                  .'" READONLY>','left','','valign="middle"');
    echo "</form>\n";
    echo "<!-- ----------------- end csv import form  ---------------------- -->\n";
    echo "</tr>\n";

    echo "</table>\n</center>\n";

    // revert domain
    bindtextdomain('squirrelmail',SM_PATH . 'locale');
    textdomain('squirrelmail');
}

/**
 * returns size integer formated in bytes, Kbytes or Mbytes
 * @param integer $size size in bytes
 * @return string formated size string
 */
function aie_display_size($size) {
    // make sure that it is integer.
    $size=(int) $size;

    $ret='';

    if ($size >= (1024*1024)) {
        $ret = sprintf(_("%s MB"),round($size/(1024*1024),1));
    } elseif ($size >= 1024) {
        $ret = sprintf(_("%s KB"),round($size/1024,1));
    } else {
        $ret = sprintf(_("%s B"),$size);
    }
    return $ret;
}

/**
 * Prints selection boxes in imported data table headers
 * 
 * Send the field numbers entered in the text boxes by the user back to 
 * this script for more processing
 * email is handled differently, not being an array
 * @param integer $csvmax max number of columns
 * @param integer $column column number
 */
function aie_create_Select($csvmax,$column) {
    // $column is the one that should be selected out of the bunch
    echo "<select name=\"COL$column\">\n";

    if($column > 5)
        $column = 5; // So we have only our normal choices. 

    for($temp = 0; $temp <= 5; $temp++) {
        echo "<option value=\"$temp\"";
        if ($column==$temp)
            echo " selected";
        if ($temp == 0)
            echo '>' . _("Nickname") . "</option>\n";
        if ($temp == 1)
            echo '>' . _("First Name") . "</option>\n";
        if ($temp == 2)
            echo '>' . _("Last Name") . "</option>\n";
        if ($temp == 3)
            echo '>' . _("Email") . "</option>\n";
        if ($temp == 4)
            echo '>' . _("Additional Info") . "</option>\n";
        if ($temp == 5)
            echo '>' . _("Do Not Include") . "</option>\n";
    }
    echo "</select>\n";
}

/**
 * @param string $row
 * @return array
 */
function aie_CSVProcess($row) {
    if (preg_grep("/((?:\/ou\=)|(?:\/cn\=)|(?:\/o\=))/",$row)) {
        $temprow = join(",",$row);
        // i18n: %s contains data from imported row.
        $return[] = sprintf(_("Row '%s' contains LDIF email address. This is not currently supported."),
                            htmlspecialchars($temprow))."\n";
        return $return;
    }

    // detect header row
    if (preg_grep("/((?:First Name)|(?:Last Name)|(?:E-mail Address))/",$row)) {
        foreach($row as $key => $value) {
            if ($value == "First Name" ) { 
                if(isset($_SESSION['csvorder'][$key])) { 
                    $_SESSION['csvorder'][1] = $_SESSION['csvorder'][$key]; 
                } else { 
                    $_SESSION['csvorder'][1]= $key; 
                }
            }
            if ($value == "Last Name" ) { 
                if(isset($_SESSION['csvorder'][$key])) { 
                    $_SESSION['csvorder'][2] = $_SESSION['csvorder'][$key]; 
                } else { 
                    $_SESSION['csvorder'][2]= $key; 
                }
            }
            if ($value == "E-mail Address" ) { 
                if(isset($_SESSION['csvorder'][$key])) { 
                    $_SESSION['csvorder'][3] = $_SESSION['csvorder'][$key]; 
                } else { 
                    $_SESSION['csvorder'][3]= $key; 
                }
            }
        }
        return array();
    }

    if (count($_SESSION['csvorder']) > 0) {
        // This is swapping elements to make firstname, last name, and email be in the 1,2,3 spot, respectively
        foreach($_SESSION['csvorder'] as $key => $value) {
            $temp = $row[$key];
            $row[$key] = $row[$value];
            $row[$value] = $temp;
        }
        return $row;
    }
    return $row;
}
?>