<?php
/**
 * address_book_import.php
 *
 * Copyright (c) 1999-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Import csv files for address book
 * This takes a comma delimited file uploaded from addressbook.php
 * and allows the user to rearrange the field order to better
 * fit the address book. A subset of data is manipulated to save time.
 * @version $Id: address_book_import.php,v 1.8 2005/03/25 14:07:41 tokul Exp $
 * @package sm-plugins
 * @subpackage abook_import_export
 */

/** @ignore */
define( 'SM_PATH' , '../../');

/** load main squirrelmail files */
include_once(SM_PATH . 'include/validate.php');
/** load addres book functions */
include_once(SM_PATH . 'functions/addressbook.php');
/** load error_box() and sqm_baseuri() functions */
include_once(SM_PATH . 'functions/display_messages.php');
/** load plugin's functions (including configuration) */
include_once(SM_PATH . 'plugins/abook_import_export/functions.php');

// Local Variables
$errorstring = '';
$finish = '';
$csvmax = 0;
$key = 0;
$x = 0;
$row = 0;
$cols = 0;
$colspan = 0;
$c = 0;
$error = 0;
$reorg = array();
$selrow = '';

global $color;
   
if (! sqGetGlobalVar('finish',$finish,SQ_POST)) {
    // Stage 1. Process uploaded file

    displayPageHeader($color, "None");

    // switch domain
    bindtextdomain('abook_import_export',SM_PATH . 'locale');
    textdomain('abook_import_export');

    // Check to make sure the user actually put a file in the upload file box.
    $smusercsv = $_FILES['smusercsv'];

    if ($smusercsv['tmp_name'] == '' || $smusercsv['size'] == 0) {
        // TODO: add processing of php 4.2.0+ 'error' codes.
        echo '<br><br>'
            .'<table align="center">'
            .'<tr><td>';
        // i18n: %s tags are used to create html link to main address book page.
        echo sprintf(_("Please select a file for uploading. You can do this by clicking on the browse button on the %sAddress Book%s page."),'<a href="' . sqm_baseuri() .  'src/addressbook.php">','</a>');
        echo '</td></tr>'
            .'</table>'
            .'</body></html>';
        exit;
    } elseif ( $smusercsv['size'] > $aie_csv_maxsize ) {
        // i18n: %s displays 'somenumber B', 'somenumber KB' or 'somenumber MB'.
        error_box(sprintf(_("Imported CSV file is too big. Contact your system administrator, if you want to import files, that are bigger than %s."),aie_display_size($aie_csv_maxsize)),$color);
        echo "</body></html>\n";
        exit;
    }

    /**
     * Use file() to get the data from the php temp file into an array so
     * that we don't have to save files on the server. 
     */

    // These shouldn't be set at all at this point. 
    $_SESSION['csvdata'] = array(); 
    $_SESSION['csvorder'] = array();

    // FIXME: don't open uploaded file directly. Move it to SM temp directory before using it.
    $csvfile = @fopen($smusercsv['tmp_name'],"r");

    if (!$csvfile) {
        echo '<br><br>'
            .'<table align="center">'
            .'<tr><td>'
            ._("Error, could not open address file.")
            .'</td></tr>'
            .'</table>';
        exit;
    }

    // FIXME: add different field delimiter option
    while ($csvarray = fgetcsv($csvfile,$smusercsv['size'])) {
        // Let fgetcsv deal with splitting the line into it's parts. (I.E. it deals with quoted commas right.
        $temp = aie_CSVProcess($csvarray);

        if (count($temp) >2) {
            $_SESSION['csvdata'][$key] = $temp;
            $key++;
        } elseif (isset($temp[0])) { 
            // This means it returned an error
            // FIXME: htmlentities are used to nuke all 8bit symbols. Find other way to sanitize output.
            $errorstring .= '<li>' . htmlentities($temp[0]) . '</li>';
        }

        // After this, the function was just doing some calculations, and returned without a problem.
        if(count($csvarray) > $csvmax) {
            $csvmax = count($csvarray);
        }
    }

    unset($_SESSION['csvorder']);

    // FIXME: create final import form only when some data is available
    echo '<form method="post" action="' . $PHP_SELF . '">';

    echo '<center><table width="95%" frame="void" cellspacing="1">';    // user's data table

    // Here I will create the headers that I want.
    echo '<tr bgcolor="' . $color[9] . '" align="center">';
    // Title of column with row numbers
    echo '<td width="1">' .  _("No#") . '</td>';
    // Title of column with omit checkbox
    echo '<td width="1">' .  _("Omit") . '</td>';

    for($x = 0; $x < $csvmax; $x++) { // The Drop down boxes to select what each column is
        echo '<td>';
        aie_create_Select($csvmax,$x);
        echo '</td>';
    }

    echo '</tr>';

    while ($row < count($_SESSION['csvdata'])) {
        if (count($_SESSION['csvdata'][$row]) >= 5) {    // This if ensures the minimum number of columns
            $cols = count($_SESSION['csvdata'][$row]);    // so importing can function for all 5 fields
        } else {
            $cols = 5;
        }

        // unused
        // $colspan = $cols + 1;

        if ($row % 2) {                   // Set up the alternating colored rows
            echo '<tr bgcolor="' . $color[0] . '">';
        } else {
            echo '<tr>';
        }

        // print row number (start counter from 1 and not from 0)
        echo '<td width="1" align="center">' . ($row+1) . '</td>';
        // Print the omit checkbox, to be checked before write
        echo '<td width="1" align="center"><input type="checkbox" name="sel' . $row . '"></td>';

        for($c = 0; $c < $cols; $c++) { // For each column in the current row
            if (isset($_SESSION['csvdata'][$row][$c]) 
                && $_SESSION['csvdata'][$row][$c] != '') {
                // if not empty, put data in cell.
                echo '<td NOWRAP>' . $_SESSION['csvdata'][$row][$c] . '</td>';
            } else {
                // if empty, put space in cell keeping colors correct.
                echo '<td>&nbsp;</td>';
            }
        }
        echo '</tr>';
        $row++;
    }

    echo '</table></center><br />';
    // display import button only after table is loaded
    echo '<input type="submit" name="finish" value="' . _("Finish") . '" tabindex="4">';

    // try initializing address book. don't display errors
    $abook = addressbook_init(false, true);
    // FIXME: check if $abook object is created
    if ( is_object($abook) && $abook->numbackends > 1 ) {
        echo "<br />\n";
        echo _("Add to addressbook:")." ";
        echo '<select name="backend">';
        $backends = $abook->get_backend_list();
        while (list($undef,$v) = each($backends)) {
            if ($v->writeable) {
                echo '<option value="' . $v->bnum;
                echo '" />' . $v->sname . "\n";
            }
        }
        echo "</select>";
    } else {
        echo '<input type="hidden" name="backend" value="1">';
    }
    // close form
    echo '</form>';

    if(strlen($errorstring)) {   
        echo _("The following rows have errors")
            . ': <br /><ul>' . $errorstring . '</ul>';
    }

    // no need to revert domain
    // bindtextdomain('squirrelmail',SM_PATH . 'locale');
    // textdomain('squirrelmail');
} else {
    // Stage 2. save addresses

    /** create address book object without remote backends */
    $abook = addressbook_init(true, true);

    while($row < count($_SESSION['csvdata'])) {
        if (count($_SESSION['csvdata'][$row]) >= 5) {    // This if ensures the minimum number of columns
            $cols = count($_SESSION['csvdata'][$row]);    // so importing can function for all 5 fields
        } else {
            $cols = 5;
        }

        $reorg = array('', '', '', '', '');

        for ($c=0; $c < $cols; $c++) {
            // Reorganize the data to fit the header cells that the user chose
            // concatenate fields based on user input into text boxes.
            $column = "COL$c";

            // check if form posts call needed columns
            if(sqGetGlobalVar($column,$colno,SQ_POST)) {
                if($colno != 5)  {
                    if ($colno == 4) {
                        $reorg[4] .= $_SESSION['csvdata'][$row][$c] . ";";
                    } else {
                        $reorg[$colno] = $_SESSION['csvdata'][$row][$c];
                        $reorg[$c] = trim($reorg[$c],"\r\n \"");
                    }
                }
            }
        }

        if (isset($reorg[4])) {
            $reorg[4] = trim($reorg[4],";");
        }

        $_SESSION['csvdata'][$row] = $reorg;
        unset($reorg); // So that we don't get any weird information from a previous rows

        // If finished, do the import. This uses Pallo's excellent class and object stuff 
        $selrow = 'sel' . $row;

        // import row only when Omit option is not set.
        if (! sqGetGlobalVar($selrow,$testvar,SQ_POST)) {
            if (eregi('[ \\:\\|\\#\\"\\!]', $_SESSION['csvdata'][$row][0])) {
                $_SESSION['csvdata'][$row][0] = '';
            }

            // Here we should create the right data to input 
            if (count($_SESSION['csvdata'][$row]) < 5) {
                array_pad($_SESSION['csvdata'][$row],5,'');
            }

            $addaddr['nickname']  = $_SESSION['csvdata'][$row][0];
            $addaddr['firstname'] = $_SESSION['csvdata'][$row][1];
            $addaddr['lastname']  = $_SESSION['csvdata'][$row][2];
            $addaddr['email']     = $_SESSION['csvdata'][$row][3];
            $addaddr['label']     = $_SESSION['csvdata'][$row][4];

            if (! sqGetGlobalVar('backend',$backend,SQ_POST)) {
                $backend=$abook->localbackend;
            } else {
                // make sure that it is integer
                $backend=(int) $backend;
            }

            if ( ! $abook->add($addaddr,$backend)) {
                // displays row number that can't be imported. SquirrelMail 
                // address book backend error message is displayed after it.
                $errorstring .= sprintf(_("Row %d:"),($row+1)) . ' ' . $abook->error . "<br />\n";
                $error++;
            }

            unset($addaddr); // Also so we don't get any weird information from previous rows
        }

        $row++;
    }

    unset($_SESSION['csvdata']); // Now that we've uploaded this information, we dont' need this variable anymore, aka cleanup

    // Since we will print something to the page at this point
    displayPageHeader($color, "None");

    bindtextdomain('abook_import_export',SM_PATH . 'locale');
    textdomain('abook_import_export');

    // Print out that we've completed this operation
    if ($error) {
        echo '<br />'
            . _("There were errors uploading the data, as listed below. Entries not listed here were uploaded.") 
            . '<br /> ' . $errorstring . '<br /> ';
    } else {
        echo '<br /><br /><center><h1><strong>' 
            ._("Upload Completed!")
            .'</strong></h1>'
            .'<p>' . _("Click on the link below to verify your work.") . '</p>'
            .'</center>';
    }

    echo '<br /><br /><p align="center"><a href="' . sqm_baseuri() . 'src/addressbook.php">' . _("Addresses") . '</a></p>';

    // no need to revert domain.
    // bindtextdomain('squirrelmail',SM_PATH . 'locale');
    // textdomain('squirrelmail');
}
?>
</body>
</html>
