<?php
/**
 * Address Book CSV Export script
 * Copyright (c) 1999-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 * @version $Id: address_book_export.php,v 1.4 2005/03/16 17:04:00 tokul Exp $
 * @package sm-plugins
 * @subpackage abook_import_export
 */

/** @ignore */
define('SM_PATH', '../../');
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/addressbook.php');

/*
 * Main Code
 */
global $username;

// Extract user agent string from server vars
// set it to unknown, if data is not available
// TODO: check why it was extracted from $_ENV 
if (! sqGetGlobalVar('HTTP_USER_AGENT',$useragent,SQ_SERVER)) {
    $useragent='unknown';
}

// FIXME: add init checks
$abook = addressbook_init(true,true);
$rows = $abook->list_addr();

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

header('Cache-control: private', false);
header('Content-Type: application/CSV');
if(preg_match('/MSIE 5.5/',$useragent) ||
   preg_match('/MSIE 6.0/',$useragent)) {
    header('Content-Disposition: filename="' . $username . '-addresses.csv"');
} else {
    header('Content-Disposition: attachment; filename="' . $username . '-addresses.csv"');
}

foreach($rows as $row) {
    echo implode(',', array_slice($row, 0, -2)) . "\n";
}

?>
