<?php

/**
 * listMembers.php
 *
 * 2002 @ Kelvin Ho. abook_group_plugin v0.1
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * List Group members
 */

chdir('..');
require_once('../src/validate.php');
require_once('../functions/date.php');
require_once('../functions/smtp.php');
require_once('../functions/display_messages.php');
require_once('../functions/addressbook.php');
require_once('../functions/plugin.php');
include_once('../functions/strings.php');
include_once('../plugins/abook_group/abook_group_database.php');
include_once('../plugins/abook_group/abook_group_functions.php');

/* --- End functions --- */

global $mailbox, $username;
displayPageHeader($color, $mailbox);

/* Initialize addressbook */
$abook = addressbook_init();

$myparams = array();
$myparams['dsn'] = $addrbook_dsn;
$myparams['table'] = 'addressgroups';
$myparams['owner'] = $username;

$abookGroups = new abook_group_database($myparams);

if (isset($remove) && !empty($remove)){
       if (isset($nickNameBackEnd) && !empty($nickNameBackEnd)){

           $userData = explodeUserArray($nickNameBackEnd);

           $abookGroups->removeFromGroup($userData, $groupName);

           if ($abookGroups->error){
               $message = "<P ALIGN=center><STRONG>".$abookGroups->error."</STRONG></P>";
           } else{
               $message =  "<P ALIGN=center><STRONG>Remove Successful</STRONG></P>";
           }
       }	


}

$myGroupMembers = $abookGroups->list_groupMembers($groupName);

?>

<table width="95%" align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center>
        <b> 
        <?php echo $groupName ?>&nbsp;
        <?php echo _("Members") ?>
        </b> 
      </center>
</td></tr></table>
<form name="form" method="post" action="<?php echo $PHP_SELF ?>">
  <p align="center"><b>
    <?php echo $message ?>
    </b></p>
<?php if(count($myGroupMembers)>0) { ?>	
  <table width="95%" align="center">
    <?php

    for ($j=0;$j<count($myGroupMembers);$j++){
        $name = $myGroupMembers[$j]['name'];
		$nickName = $myGroupMembers[$j]['nickname'];
		$backendName = $abook->backends[$myGroupMembers[$j]['backend']]->sname;
?>		
<tr><td>

        <input type="checkbox" name="nickNameBackEnd[]" value="<?php echo $nickName.",".$backendName ?>">
      
    </td><td><?php echo $name ?></td></tr>		
<?php
    }
?>
</table>
<?php
} //end count > 0
else{
	echo "<p><center>"._("You Currently Do Not Have Any Members In This Group")."</center></p>";
}
?>

  <p align="center">
    <input type="hidden" name="groupName" value="<?php echo $groupName ?>">
    <input type="submit" name="remove" value="Remove">
  </p>
</form>
<?php display_abook_group_footer(); ?>
</body></html>
