<?php

/**
  * group_selector.tpl
  *
  * Template for displaying a group selection widget and
  * associated buttons on the address book list page for
  * the Address Book Grouping and Pagination plugin.
  *
  * The following variables are available in this template:
  *
  * int    $size            The requested size of the selector, although 
  *                         the template should know what's ultimately
  *                         the best sizing
  * int    $backend         The backend number for which this widget is
  *                         being built
  * array  $all_groups      A list of all the user's groups
  * array  $selected_groups A list of the groups that shoud be preselected
  * string $select_style    "multiple" if a multi-select box should be shown,
  *                         or "single" if a single-select (drop-down) should
  *                         be shown
  *
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage abook_group_pagination
  *
  */


// retrieve the template vars
//
extract($t);


echo '<select name="abook_groups_' . $backend . '[]"'
   . ($select_style == 'multiple' ? ' multiple="multiple" size="' . $size . '"' : '')
   . '>';
foreach ($all_groups as $group)
{
   echo '<option value="' . $group . '"'
      . (in_array($group, $selected_groups) ? '" selected="selected"' : '')
      . '>' . $group . "</option>\n";
}
echo '</select><input type="submit" name="abook_groupadd_'
   . $backend . '" value="' . _("Add")
   . '"><input type="submit" name="abook_groupdel_'
   . $backend . '" value="' . _("Remove") . '">';

