<?php

   /**
    **  setup.php -- abook_group plugin
    **
    **  2002 @ Kelvin Ho. abook_group_plugin v0.1
    **  Licensed under the GNU GPL. For full terms see the file COPYING.
    **
    **  This is a standard Squirrelmail-1.2 API for plugins.
    **/
    include_once(SM_PATH . 'functions/i18n.php');

    function squirrelmail_plugin_init_abook_group() {
        /* Standard initialization API. */
        global $squirrelmail_plugin_hooks;

        $squirrelmail_plugin_hooks['compose_button_row']['abook_group'] = 
           'abook_group_setup';
        $squirrelmail_plugin_hooks['optpage_register_block']['abook_group'] = 
           'abook_group_optpage_register_block';
        $squirrelmail_plugin_hooks['options_link_and_description']['abook_group'] = 
           'abook_group_options';
    }

    function abook_group_version() {
       return '0.39b';
    }


    function abook_group_optpage_register_block() {
       // Gets added to the user's OPTIONS page.
       global $optpage_blocks;

       if ( !soupNazi() ) {

           bindtextdomain('abook_group', SM_PATH . 'plugins/abook_group/locale');
           textdomain('abook_group');

           /* Register abook_group with the $optionpages array. */
           $optpage_blocks[] = array(
               'name' => _("Address Groups"),
               'url'  => SM_PATH . 'plugins/abook_group/list_abook_group.php',
               'desc' => _("You can create address groups and add email addresses from your address book"),
               'js'   => FALSE
            );

           bindtextdomain('squirrelmail', SM_PATH . 'locale');
           textdomain('squirrelmail');
        }
    }


    function abook_group_setup() {
        /* Gets added to the COMPOSE buttons row. */
        if ( !soupNazi() ) {
            /*
            ** using document.write to hide this functionality from people
            ** with JavaScript turned off.        
            */
            bindtextdomain('abook_group', SM_PATH . 'plugins/abook_group/locale');
            textdomain('abook_group');
            echo "<script type=\"text/javascript\">\n".
                    "<!--\n".
                    'document.write("<input type=\"button\" value=\"' .
                        _("Groups") . '\" onclick=\"window.open(\'../plugins/abook_group/abook_group_interface.php\', \'abookgroup\', \'status=yes,width=550,height=370,resizable=yes,scrollbars=yes\')\">");'. "\n" .
                    "//-->\n".
                    "</script>\n";
                    bindtextdomain('squirrelmail', SM_PATH . 'locale');
                    textdomain('squirrelmail');
        }
    }
?>
