<?php

/**
 * addrbook_search.php
 *
 * 2002 @ Kelvin Ho. abook_group_plugin v0.1
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Handle addressbook searching to add into address group
 * added toggle all.
 *
 * NOTE: Modified from addrbook_search from /functions/
 */
if (!defined('SM_PATH'))define('SM_PATH','../../');

include_once(SM_PATH . 'include/validate.php');

/* List search results */
function display_result($res, $includesource = true, $javascript_on=true) {
    global $color, $abook, $srch_rslt_lines;
    if(sizeof($res) <= 0) return;
        
    $line = 0;
    echo '<TABLE BORDER="0" WIDTH="98%" ALIGN=center>' .
         '<TR BGCOLOR="' . $color[9] . '"><TH ALIGN=left>&nbsp;';
/* add javascript for toggle all*/
    if ($javascript_on) {
        echo '<a href="#" onClick="CheckAll();">' . _("Toggle All") . "</a>\n";
    }
    echo '<TH ALIGN=left>&nbsp;' . _("Name") .
         '<TH ALIGN=left>&nbsp;' . _("E-mail") .
         '<TH ALIGN=left>&nbsp;' . _("Info");

    if ($includesource) {
        echo '<TH ALIGN=left WIDTH="10%">&nbsp;' . _("Source");
    }    
    echo "</TR>\n";
    
    while (list($undef, $row) = each($res)) {
        echo '<tr';
        if ($line % 2) { echo ' bgcolor="' . $color[0] . '"'; }
        echo ' nowrap><td valign=top nowrap align=center width="5%">' .
             '<input type="checkbox" name="nickNameBackEnd[]" value="'. $row['nickname'].",". $abook->backends[$row['backend']]->sname .'"></td>'.
             '<td nowrap valign=top>&nbsp;' . $row['name'] . '&nbsp;</td><td nowrap valign=top>' .
             '&nbsp;' . $row['email'] . '&nbsp;</td>' .
             '<td valign=top>&nbsp;' . $row['label'] . '&nbsp;</td>';
        if ($includesource) {
            echo '<td nowrap valign=top>&nbsp;' . $row['source']. '&nbsp;</td>';
        }

        echo "</TR>\n";
        $line++;
    }
    $srch_rslt_lines = $line;
    echo '</TABLE>';
}

/* ================= End of functions ================= */
    
include_once(SM_PATH . 'functions/strings.php');
include_once(SM_PATH . 'functions/addressbook.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_database.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_functions.php');
    
/*  Start Globals  */

sqgetGlobalVar('srch_rslt_lines', $srch_rslt_lines, SQ_POST);
sqgetGlobalVar('color', $color, SQ_POST);
sqgetGlobalVar('abook', $abook, SQ_POST);
sqgetGlobalVar('query', $query, SQ_POST);
sqgetGlobalVar('show', $show, SQ_POST);
sqgetGlobalVar('listall', $listall, SQ_POST);
sqgetGlobalVar('addNewGroup', $addNewGroup, SQ_POST);
sqgetGlobalVar('addToGroup', $addToGroup, SQ_POST);
sqgetGlobalVar('backend', $backend, SQ_POST);
sqgetGlobalVar('newGroup', $newGroup, SQ_POST);
sqgetGlobalVar('nickNameBackEnd', $nickNameBackEnd, SQ_POST);
sqgetGlobalVar('abookGroups', $abookGroups, SQ_POST);
sqgetGlobalVar('userData', $userData, SQ_POST);
sqgetGlobalVar('myGroups', $myGroups, SQ_POST);
sqgetGlobalVar('groupName', $groupName, SQ_POST);
sqgetGlobalVar('myparams', $myparams, SQ_POST);
sqgetGlobalVar('group', $group, SQ_POST);

/*  End Globals  */

$myparams = array();
$myparams['dsn'] = $addrbook_dsn;
$myparams['table'] = 'addressgroups';
$myparams['owner'] = $username;

$abookGroups = new abook_group_database($myparams);
$abookGroups->personal_abook_table = "address";
$abookGroups->global_abook_table = "globaladdress";

//displayHtmlHeader();
displayPageHeader($color, $mailbox);
/* Initialize vars */
if (!isset($query) || isset($listall)) { $query = ''; }
if (!isset($show))  { $show  = ''; }

echo '<BODY TEXT="' . $color[8] . '" BGCOLOR="' . $color[4] . '" ' .
               'LINK="' . $color[7] . '" VLINK="'   . $color[7] . '" ' .
                                        'ALINK="'   . $color[7] . "\">\n";


/* Initialize addressbook */
$abook = addressbook_init();

/* add javascript for toggle all*/

    if ($javascript_on) {
        echo '<script language="JavaScript">' .
            "\n<!-- \n" .
            "function CheckAll() {\n" .
            "   for (var i = 0; i < document.sform.elements.length; i++) {\n" .
            "       if( document.sform.elements[i].type == 'checkbox' ) {\n" .
            "           document.sform.elements[i].checked = !(document.sform.elements[i].checked);\n".
            "       }\n" .
            "   }\n" .
            "}\n" .
            "//-->\n" .
            '</script>';
    }


/* Create search form */

    echo '<p>&nbsp;</p>';
	echo '<FORM NAME=sform ACTION="' . $PHP_SELF . '" METHOD="POST">' . "\n" ;
	echo '<TABLE BORDER="0" WIDTH="100%" >' . '<TR><TD NOWRAP VALIGN=middle>' . "\n" .
         '  <STRONG>' . _("Search for address to add") . "</STRONG>\n" .
         '  <INPUT TYPE=text NAME=query VALUE="' . htmlspecialchars($query) .
         "\" SIZE=26>\n";

    /* List all backends to allow the user to choose where to search */
    if ($abook->numbackends > 1) {
        echo '<STRONG>' . _("in") . '</STRONG>&nbsp;<SELECT NAME=backend>'."\n".
             '<OPTION VALUE=-1'. (($backend == -1) ? " SELECTED " : "").'>' . _("All address books") . "\n";
        $ret = $abook->get_backend_list();
        while (list($undef,$v) = each($ret)) {
            echo '<OPTION VALUE=' . $v->bnum . (($backend == $v->bnum) ? " SELECTED " : "") . '>' . $v->sname . "\n";
        }
        echo "</SELECT>\n";
    } else {
        echo '<INPUT TYPE=hidden NAME=backend VALUE=-1>' . "\n";
    }
        
    echo '<INPUT TYPE=submit VALUE="' . _("Search") . '">' .
         '&nbsp;|&nbsp;<INPUT TYPE=submit VALUE="' . _("List all") .
         '" NAME=listall>' . "\n" .
         '</TD><!--TD ALIGN=right>' . "\n" .
         '<INPUT TYPE=button VALUE="' . _("Close window") .
         '" onclick="parent.close();">' . "\n" .
         '</TD--></TR></TABLE>' . "\n";


/* Add New Group */
if (!empty($addNewGroup)) {
    if ($newGroup){
       if (isset($nickNameBackEnd) && !empty($nickNameBackEnd)){

           $userData = explodeUserArray($nickNameBackEnd);

           $abookGroups->addToGroup($userData, $newGroup, true);
           
           if ($abookGroups->error){
               echo "<P ALIGN=center><STRONG>".$abookGroups->error."</STRONG></P>";
           } else{
               echo "<P ALIGN=center><STRONG>Add Successful</STRONG></P>";
           }
       }
    }
    else{
        echo "<P ALIGN=center><STRONG>New Group Name is Empty</STRONG></P>";
    }
}
/* Add To Group */
elseif (!empty($addToGroup)) {

       if (isset($nickNameBackEnd) && !empty($nickNameBackEnd)){

           $userData = explodeUserArray($nickNameBackEnd);

           $abookGroups->addToGroup($userData, $group);

           if ($abookGroups->error){
               echo "<P ALIGN=center><STRONG>".$abookGroups->error."</STRONG></P>";
           } else{
               echo "<P ALIGN=center><STRONG>Add Successful</STRONG></P>";
           }
       }
}


/* Show addressbook */
    if (!empty($listall)) {

        if($backend != -1 || $show == 'blank') {
            if ($show == 'blank') {
                $backend = $abook->localbackend;
            }
            $res = $abook->list_addr($backend);

            if(is_array($res)) {
                usort($res,'alistcmp');
                display_result($res, false, $javascript_on);
            } else {
                echo '<P ALIGN=center><STRONG>' .
                     sprintf(_("Unable to list addresses from %s"),
                         $abook->backends[$backend]->sname) .
                     '</STRONG></P>' . "\n";
            }
        } else {
            $res = $abook->list_addr();
            usort($res,'alistcmp');
            display_result($res, true, $javascript_on);
        }

    } else {
        /* Empty search */
        if (empty($query) && empty($show) && empty($listall) && empty($addNewGroup) && empty($addToGroup)) {
           echo '<P ALIGN=center><BR>' ._("No persons matching your search was found") ."</P>\n";
        }

        /* Do the search */
       if (!empty($query) && empty($listall)) {
    
            if($backend == -1) {
                $res = $abook->s_search($query);
            } else {
                $res = $abook->s_search($query, $backend);
            }
        
            if (!is_array($res)) {
                echo '<P ALIGN=center><B><BR>' .
                     _("Your search failed with the following error(s)") .
                     ':<br>' . $abook->error . "</B></P>\n</BODY></HTML>\n";
                exit;
            }
        
            if (sizeof($res) == 0) {
                echo '<P ALIGN=center><BR><B>' .
                     _("No persons matching your search was found") .
                     ".</B></P>\n</BODY></HTML>\n";
                exit;
            }
        
            display_result($res, true, $javascript_on);
        }
    }
?>   
<p align="center"> 
  
<?php
 if ($srch_rslt_lines > 0) {
    echo "<TABLE>";
      $myGroups = $abookGroups->list_group();
     if (count($myGroups) > 0) {
 ?>
   <TR><TD>Add to Existing Group: <select name="group">
 <?php
     for ($i=0;$i<count($myGroups);$i++){
         $groupName = $myGroups[$i]['addressgroup'];
         echo "<option value=\"$groupName\"".(($group == $groupName)? " SELECTED ": "") .">";
         echo $groupName ."</option>";
     }
?>
  </select>
   <input type="submit" name="addToGroup" value="Add">
  </TD></TR>
  <TR><TD>&nbsp; OR</TD></TR>
 <?php
    }
 ?>
 <TR><TD>
   Add to New Group (supply group name):
   <input type="text" name="newGroup">
   <input type="submit" name="addNewGroup" value="Add">
 </TD></TR>
 <?php
 }
 echo "</TABLE></FORM>\n";

display_abook_group_footer();

echo "</BODY></HTML>\n";
   
?>
