<?php

/**
 * list_abook_group.php
 *
 * 2002 @ Kelvin Ho. abook_group_plugin v0.1
 *
 * List abook groups for modify, delete or to list group members.
 */
if (!defined('SM_PATH'))define('SM_PATH','../../');

include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/addressbook.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_database.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_functions.php');

global $mailbox, $username;

/*  Start globals  */

sqgetGlobalVar('username', $username, SQ_POST);
sqgetGlobalVar('mailbox', $mailbox, SQ_POST);
sqgetGlobalVar('myparams', $myparams, SQ_POST);
sqgetGlobalVar('abookGroups', $abookGroups, SQ_POST);
sqgetGlobalVar('myGroups', $myGroups, SQ_POST);
sqgetGlobalVar('groupName', $groupName, SQ_POST);
sqgetGlobalVar('groupNameURL', $groupNameURL, SQ_POST);

/*  End globals  */

displayPageHeader($color, $mailbox);

/* Initialize addressbook */

$myparams = array();
$myparams['dsn'] = $addrbook_dsn;
$myparams['table'] = 'addressgroups';
$myparams['owner'] = $username;

$abookGroups = new abook_group_database($myparams);
$myGroups = $abookGroups->list_group();

?>

<table width="95%" align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center><b><?php echo _("Groups") ?></b></center>
</td></tr></table>
<?php
if (count($myGroups)>0){
?>
<table width="95%" align="center">
  <?php
for ($i=0;$i<count($myGroups);$i++){
    $groupName = $myGroups[$i]['addressgroup'];
    $groupNameURL = urlencode ($groupName);
?>
  <tr> 
    <td>
      <?php echo $groupName ?>
    </td>
    <td><a href="modifyGroup.php?groupName=<?php echo $groupNameURL ?>">Modify</a> 
      | <a href="modifyGroup.php?groupName=<?php echo $groupNameURL ?>&opt=delete">Delete</a> 
      | <a href="listMembers.php?groupName=<?php echo $groupNameURL ?>">List</a></td>
  </tr>
  <?php } ?>
</table>
<?php
}
else{
?>
<p><center><?php echo _("You Currently Do Not Have Any Groups") ?></center></p>
<?php
}

display_abook_group_footer();
?>
</body></html>
