<?php

/**
 * addrbook_group_interface.php
 * 
 *
 * Copyright (c) Kelvin Ho @ 2002 . abook_groupv0.1
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Handle inserting of group members into the to, cc or bcc field
 *
 * Needs Javascript
 */
define('SM_PATH','../../');

include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'functions/display_messages.php');
include_once(SM_PATH . 'functions/addressbook.php');
include_once(SM_PATH . 'functions/plugin.php');
include_once(SM_PATH . 'functions/strings.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_database.php');
include_once(SM_PATH . 'plugins/abook_group/abook_group_functions.php');

/* Insert hidden data */
function addr_insert_hidden() {
    global $body, $subject, $send_to, $send_to_cc, $send_to_bcc, $mailbox,
           $identity;

   echo '<input type=hidden value="';
   if (substr($body, 0, 1) == "\r")
       echo "\n";
   echo htmlspecialchars($body) . '" name=body>' . "\n" .
        '<input type=hidden value="' . htmlspecialchars($subject) .
        '" name=subject>' . "\n" .
        '<input type=hidden value="' . htmlspecialchars($send_to) .
        '" name=send_to>' . "\n" .
        '<input type=hidden value="' . htmlspecialchars($send_to_cc) .
        '" name=send_to_cc>' . "\n" .
        '<input type=hidden value="' . htmlspecialchars($send_to_bcc) .
        '" name=send_to_bcc>' . "\n" .
        '<input type=hidden value="' . htmlspecialchars($identity) .
        '" name=identity>' . "\n" .
        '<input type=hidden name=mailbox value="' . htmlspecialchars($mailbox) .
        "\">\n" . '<input type=hidden value="true" name=from_htmladdr_search>' .
        "\n";
   }


/* List search results */
function addr_display_result($res, $includesource = true) {
    global $color, $PHP_SELF;

    if (sizeof($res) <= 0) return;

    echo '<form method=post action="' . $PHP_SELF . "\">\n" .
         '<input type=hidden name="html_addr_search_done" value="true">' . "\n";
    addr_insert_hidden();
    $line = 0;

    echo '<TABLE BORDER=0 WIDTH="98%" ALIGN=center>' .
         '<TR BGCOLOR="' . $color[9] . '"><TH ALIGN=left>&nbsp;' .
         '<TH ALIGN=left>&nbsp;' . _("Name") .
         '<TH ALIGN=left>&nbsp;' . _("E-mail") .
         '<TH ALIGN=left>&nbsp;' . _("Info");

    if ($includesource) {
        echo '<TH ALIGN=left WIDTH="10%">&nbsp;' . _("Source");
    }

    echo "</TR>\n";

    foreach ($res as $row) {
        echo '<tr';
        if ($line % 2) { echo ' bgcolor="' . $color[0] . '"'; }
        echo ' nowrap><td nowrap align=center width="5%">' .
             '<input type=checkbox name="send_to_search[T' . $line . ']" value = "' .
             htmlspecialchars($row['email']) . '">&nbsp;To&nbsp;' .
             '<input type=checkbox name="send_to_search[C' . $line . ']" value = "' .
             htmlspecialchars($row['email']) . '">&nbsp;Cc&nbsp;' .
             '<input type=checkbox name="send_to_search[B' . $line . ']" value = "' .
             htmlspecialchars($row['email']) . '">&nbsp;Bcc&nbsp;' . 
             '</td><td nowrap>&nbsp;' . $row['name'] . '&nbsp;</td>' .
             '<td nowrap>&nbsp;' . $row['email'] . '&nbsp;</td>' .
             '<td nowrap>&nbsp;' . $row['label'] . '&nbsp;</td>';
         if ($includesource) {
             echo '<td nowrap>&nbsp;' . $row['source'] . '&nbsp;</td>';
         }
         echo "</tr>\n";
         $line ++;
    }
    echo '<TR><TD ALIGN=center COLSPAN=';
    if ($includesource) { echo '4'; } else { echo '5'; }
    echo '><INPUT TYPE=submit NAME="addr_search_done" VALUE="' .
         _("Use Addresses") . '"></TD></TR>' .
         '</TABLE>' .
         '<INPUT TYPE=hidden VALUE=1 NAME="html_addr_search_done">' .
         '</FORM>';
}

/* --- End functions --- */

global $mailbox, $username;
displayHtmlHeader();

/* Initialize addressbook */

$myparams = array();
$myparams['dsn'] = $addrbook_dsn;
$myparams['table'] = 'addressgroups';
$myparams['owner'] = $username;

$abookGroups = new abook_group_database($myparams);
$abookGroups->personal_abook_table = "address";
$abookGroups->global_abook_table = "globaladdress";

$myGroups = $abookGroups->list_group();

insert_javascript();
?>

<table width="95%" align=center cellpadding=2 cellspacing=2 border=0>
<tr><td bgcolor="<?php echo $color[0] ?>">
   <center><b><?php echo _("Groups") ?></b></center>
</td></tr></table>
<?php if (count($myGroups)>0) { ?>
<table> <tr><td></td><td>Groupname</td></tr>
<?php
for ($i=0;$i<count($myGroups);$i++){
    $groupName = $myGroups[$i]['addressgroup'];
    $myGroupMembers = $abookGroups->list_groupMembers($groupName);
    $to_address = "";
    $cc_address = "";
    $bcc_address = "";
    for ($j=0;$j<count($myGroupMembers);$j++){
        $to_address .= "to_address('{$myGroupMembers[$j]['email']}');";
        $cc_address .= "cc_address('{$myGroupMembers[$j]['email']}');";
        $bcc_address .= "bcc_address('{$myGroupMembers[$j]['email']}');";
    }
    
?>
<tr><td><a href="javascript:<?php echo $to_address ?>">To</a> <a href="javascript:<?php echo $cc_address ?>">Cc</a> <a href="javascript:<?php echo $bcc_address ?>">Bcc</a></td><td><?php echo $groupName ?></td></tr>
<?php } ?>
</table>
<?php
}
else{
    echo  "There are no groups available for selection";
}
?>
</body></html>
