<?php
   /*
    *  Change MySQL Password plugin 3.1
    *
    */

   chdir ('..');
   if (!defined('SM_PATH')) define('SM_PATH','../');

   

   // include compatibility plugin
   //
   if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');



   // get global variables for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS, $HTTP_POST_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
      $_POST = $HTTP_POST_VARS;
   }


   global $color;
   global $mysql_server, $mysql_database, $mysql_table, $mysql_userid_field,
          $mysql_password_field, $mysql_manager_id, $mysql_manager_pw,
          $mysql_saslcrypt, $mysql_unixcrypt, $mysql_MD5crypt,
          $use_ssl_for_password_change, $mysql_password_force,
          $mysql_password_change_field, $mysql_password_change_field_delimiter,
          $mysql_password_change_yes_value, $mysql_password_change_no_value,
          $split_username_query, $split_username_expression, 
          $split_username_domain_field, $debug;


   $isForceChange = stristr($_SERVER['PHP_SELF'], 'right_main.php')
                 || stristr($_SERVER['PHP_SELF'], 'webmail.php');


   if (!$isForceChange)
   {

      if (compatibility_check_sm_version(1, 3))
      {
         include_once (SM_PATH . 'include/validate.php');
         include_once (SM_PATH . 'functions/page_header.php');
         include_once (SM_PATH . 'functions/imap.php');
         include_once (SM_PATH . 'include/load_prefs.php');
         include_once (SM_PATH . 'functions/i18n.php');
         include_once (SM_PATH . 'config/config.php');
         include_once (SM_PATH . 'functions/strings.php');
         include_once (SM_PATH . 'functions/imap.php');

         global $use_ssl_for_password_change;
         include_once (SM_PATH . 'plugins/change_mysqlpass/config.php');
      }
      else
      {
         include_once ('../src/validate.php');
         include_once ('../functions/page_header.php');
         include_once ('../functions/imap.php');
         include_once ('../src/load_prefs.php');
         include_once ('../functions/i18n.php');
         include_once ('../config/config.php');
         include_once ('../functions/strings.php');
         include_once ('../functions/imap.php');

         global $use_ssl_for_password_change;
         include_once ('../plugins/change_mysqlpass/config.php');
      }

   }


   // get flag that tells us if this is a password submission attempt...
   //
   if (isset($_POST['plugin_change_mysqlpass']))
      $plugin_change_mysqlpass = $_POST['plugin_change_mysqlpass'];




   // make sure this page is encrypted so passwords can't be sniffed
   // (only if flag is on)
   //
   if ($use_ssl_for_password_change) {

      if (!isset($_SERVER['HTTPS'])) {

         $location = 'https://' . $_SERVER['HTTP_HOST']
            . $_SERVER['REQUEST_URI'];

         header("Location: $location");
         exit(0);

      }

   }


   // determine URL for redirection if Cancel is pressed
   // (non https if the flag is on, otherwise, use what
   // was already there)
   //   
   if (!$use_ssl_for_password_change)
       $cancelLocation = 'http' . (isset($_SERVER["HTTPS"]) ? 's' : '');
   else
       $cancelLocation = 'http';

   ereg("(^.*/).*", $_SERVER['REQUEST_URI'], $regs);
   $cancelLocation .= '://' . $_SERVER['HTTP_HOST']
      . $regs[1] . '../../src/options.php?optmode=submit&plugin_change_mysqlpass=0';


   // if a password change is given, check its validity
   //
   if (isset($plugin_change_mysqlpass))
   {
       $Messages = change_mysqlpass_check();

       // the above only returns if password wasn't changed
       // so if we came from webmail.php, must redirect to
       // right_main.php (need to pass messages along...)
       //
       if (stristr($_SERVER['PHP_SELF'], 'webmail.php'))
       {
          $location = $_SERVER['PHP_SELF'];
          $location = str_replace('webmail.php', 'right_main.php', $location);
          $location .= '?messages=';
          foreach($Messages as $message) $location .= urlencode($message . '||');

          header('Location: ' . $location);
          exit(0);
       }
   }

        
   // don't display page header if we got a successful
   // password change (No error messages exist and a 
   // password was submitted.  Cannot send output before 
   // header() call)
   //
   if (!isset($Messages) && isset($cp_oldpass) && $cp_oldpass)
   {
      // do nothing
   }
   else
   {
      // if not in force password change mode, we 
      // still need to send a page header
      //
      if (!$isForceChange)
      {
         displayPageHeader($color, 'None', 'document.forms[0].elements["cp_oldpass"].focus();');
         echo '<br>';
      }

      echo '<table width=95% align=center cellpadding=2 cellspacing=2 border=0>';
      echo '<tr><td bgcolor="';
 
      if (!$isForceChange)
         echo $color[0] . '">';
      else
         echo $color[2] . '">';
   
   }
   

   echo '<center><b>';
   echo _("Change Password"); if ($use_ssl_for_password_change) echo ' - ' . _("Secure"); 
   echo '</b></center></td>';


if (isset($Messages) && count($Messages)) {
    echo "<tr><td>\n";
    foreach ($Messages as $line) {
        echo htmlspecialchars($line) . "<br>\n";
    }
    echo "</td></tr>\n";
}

?><tr><td>
<?php 

	if ($_SERVER['PHP_SELF']) {
		$location=$_SERVER['PHP_SELF'];
	} else {
		$location="../plugins/change_mysqlpass/options.php";
	}

        $location = str_replace('right_main.php', 'webmail.php', $location);

?>
    <form method=post action="<?php echo $location; ?>">
    <table>
      <tr>
        <th align=right><?php echo _("Old Password"); ?>:</th>
        <td><input type=password name=cp_oldpass value=""  size=20></td>
      </tr>
      <tr>
        <th align=right><?php echo _("New Password"); ?>:</th>
        <td><input type=password name=cp_newpass value="" size=20></td>
      </tr>
      <tr>
        <th align=right><?php echo _("Verify New Password"); ?>:</th>
        <td><input type=password name=cp_verify value="" size=20></td>
      </tr>
      <tr>
        <td align=right colspan=2>
          <input type="hidden" name="plugin_change_mysqlpass" value="1">
          <input type=submit value="<?php echo _("Submit"); ?>">
<?php 

   if (!$isForceChange)

     echo '<input type=button value="' . _("Cancel") . '" onClick="document.location=\'' . $cancelLocation . '\'"'
        . ' name="plugin_change_mysqlpass_cancel">';

?>
        </td>
      </tr>
    </table>
</td></tr>
</tr></table>
</body></html>
<?php

exit(0);


function change_mysqlpass_check() {
   global $cp_oldpass, $cp_newpass, $cp_verify, $key, $onetimepad;
   global $plugin_change_ldappass;


   // get global variables for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SESSION_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS;
      $_SESSION = $HTTP_SESSION_VARS;
      $_POST = $HTTP_POST_VARS;
      $_COOKIE = $HTTP_COOKIE_VARS;
   }


   $Messages = array();
   $password = OneTimePadDecrypt($_COOKIE['key'], $_SESSION['onetimepad']);

   $cp_oldpass = $_POST['cp_oldpass'];
   $cp_newpass = $_POST['cp_newpass'];
   $cp_verify = $_POST['cp_verify'];

   if ($cp_oldpass == '')
       array_push($Messages, _("You must type in your old password."));
   if ($cp_newpass == '')
       array_push($Messages, _("You must type in a new password."));
   if ($cp_verify == '')
       array_push($Messages,
           _("You must also type in your new password in the verify box."));
   if ($cp_newpass != '' && $cp_verify != $cp_newpass)
       array_push($Messages,
           _("Your new password does not match the verify password."));
   if ($cp_oldpass != '' && $cp_oldpass != $password)
       array_push($Messages, _("Your old password is not correct."));

   if ($cp_oldpass == $cp_newpass)
	array_push($Messages, _("Your new password must be different than your old password."));

   if (count($Messages))
       return $Messages;

   return change_mysqlpass_go($password);
}


function change_mysqlpass_go($password) {

    global $mysql_server, $mysql_database, $mysql_table, $mysql_userid_field,
           $mysql_password_field, $mysql_manager_id, $mysql_manager_pw,
           $mysql_saslcrypt, $mysql_unixcrypt, $mysql_MD5crypt,
           $use_ssl_for_password_change, $mysql_password_force,
           $mysql_password_change_field, $mysql_password_change_field_delimiter,
           $mysql_password_change_yes_value, $mysql_password_change_no_value,
           $split_username_query, $split_username_expression, 
           $split_username_domain_field, $debug, $update_clear_passwd_field;


    // get global variables for versions of PHP < 4.1
    //
    if (!compatibility_check_php_version(4, 1)) {
       global $HTTP_SESSION_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_SERVER_VARS;
       $_SESSION = $HTTP_SESSION_VARS;
       $_SERVER = $HTTP_SERVER_VARS;
       $_POST = $HTTP_POST_VARS;
       $_COOKIE = $HTTP_COOKIE_VARS;
    }


    if (file_exists("../plugins/change_mysqlpass/config.php"))
	include_once ('../plugins/change_mysqlpass/config.php');
    if (file_exists("./plugins/change_mysqlpass/config.php"))
	include_once ('./plugins/change_mysqlpass/config.php');
    if (file_exists("./plugins/change_mysqlpass/md5crypt.php"))
	include_once ('./plugins/change_mysqlpass/md5crypt.php');
    if (file_exists("../plugins/change_mysqlpass/md5crypt.php"))
	include_once ('../plugins/change_mysqlpass/md5crypt.php');
    if (file_exists("./plugins/change_mysqlpass/generate.php"))
	include_once ('./plugins/change_mysqlpass/generate.php');
    if (file_exists("../plugins/change_mysqlpass/generate.php"))
	include_once ('../plugins/change_mysqlpass/generate.php');

    $Messages = array();

    $cp_newpass = $_POST['cp_newpass'];
    $username = $_SESSION['username'];
    $base_uri = $_SESSION['base_uri'];
    $onetimepad = $_SESSION['onetimepad'];
    $key = $_COOKIE['key'];

    $user = $username;
    if ($split_username_query)
    {
        list($user, $domain) = preg_split('/' . $split_username_expression . '/', $username);
    }

    if ($debug)
        array_push($Messages, 'Connecting to Database');

    $ds=mysql_connect($mysql_server, $mysql_manager_id, $mysql_manager_pw);
    if (! $ds) {
        array_push($Messages, _("Cannot connect to Database Server, please try later!"));
        return $Messages;
    }

    if (!mysql_select_db($mysql_database,$ds)) {
        array_push($Messages, _("Database not found on server"));
        return $Messages;
    }

    $query_string = 'SELECT ' . $mysql_userid_field . ',' . $mysql_password_field
                  . ' FROM '  . $mysql_table
                  . ' WHERE ' . $mysql_userid_field . '="' . $user;

    if ($split_username_query)
    {
        $query_string .= '" AND ' . $split_username_domain_field . '="' . $domain;
    }

    if ($mysql_saslcrypt) {
        $query_string .= '" AND ' . $mysql_password_field; 

        // extra secure - match manually entered old password 
        // against the database instead of using one from cookie
        //
        $query_string .= '=password("' . $_POST['cp_oldpass'] . '")';
        //$query_string .= '=password("' . $password . '")';

    } elseif ($mysql_unixcrypt) {
        $query_string .= '" AND ' . $mysql_password_field; 

        // extra secure - match manually entered old password 
        // against the database instead of using one from cookie
        //
        $query_string .= '=encrypt("' . $_POST['cp_oldpass'] . '", ' . $mysql_password_field . ')';
        //$query_string .= '=encrypt("' . $password . '", ' . $mysql_password_field . ')';

    } elseif ($mysql_MD5crypt) {
        $query_string .= '"';
    } else {
        $query_string .= '" AND ' . $mysql_password_field; 

        // extra secure - match manually entered old password 
        // against the database instead of using one from cookie
        //
        $query_string .= '="' . $_POST['cp_oldpass'] . '"';
        //$query_string .= '="' . $password . '"';

    }
  
    if ($debug)
        array_push($Messages,$query_string);

    $select_result = mysql_query($query_string, $ds);

    if ($mysql_MD5crypt) {
	$passwordfield=mysql_result($select_result, 0, $mysql_password_field);
	$pwd=preg_split('/\$/', $passwordfield);

	$salt=$pwd[2];
	$hash=$pwd[3];
	
        // extra secure - match manually entered old password 
        // against the database instead of using one from cookie
        //
        $md5pwd=md5crypt($_POST['cp_oldpass'], $salt);
	//$md5pwd=md5crypt($password, $salt);

    }

    if (!$select_result) {
        array_push($Messages, _("SQL call failed, try again later."));
        return $Messages;
    }

    if ($debug)
        array_push($Messages,'Returned '.mysql_num_rows($select_result).' rows.');

    if ($mysql_MD5crypt) {
	if ($md5pwd != $passwordfield) {
	
		# Verify for crypt password
		$seed=$passwordfield[0].$passwordfield[1];
		$check=crypt($password, $seed);

		if ($check != $passwordfield) {		
			array_push($Messages, _("Strange, your old password does not match the database... rejecting."));
			return $Messages;
		}
	}
    } else {

    if (mysql_num_rows($select_result) == 0) {
        array_push($Messages, _("Strange, your old password does not match the database... rejecting."));
        return $Messages;
    }
    if (mysql_num_rows($select_result) > 1) {
//make sure we only have 1 uid
        array_push($Messages, _("Duplicate login entries detected, cannot change password!"));
        return $Messages;
    }
    }

    $update_string =  'UPDATE '. $mysql_table . ' SET ' . $mysql_password_field;

    if ($mysql_saslcrypt)
        $update_string .= '=password("' . $cp_newpass . '")';
    elseif ($mysql_unixcrypt)
        $update_string .= '=encrypt("' . $cp_newpass . '")';
    elseif ($mysql_MD5crypt) {
	$seed=generate_seed();
	$md5pwd=md5crypt($cp_newpass, $seed);
	$update_string .= '="' . $md5pwd . '"';
    } else
        $update_string .= '="' . $cp_newpass . '"';

    if (isset($update_clear_passwd_field) && !empty($update_clear_passwd_field))
       $update_string .= ', ' . $update_clear_passwd_field . '="'
                      . $cp_newpass . '"';

    $update_string .= ' WHERE ' . $mysql_userid_field . '="' . $user . '"';

    if ($split_username_query)
    {
        $update_string .= ' AND ' . $split_username_domain_field . '="' . $domain. '"';
    }

    if ($debug)
        array_push($Messages,$update_string);

    if (mysql_query($update_string,$ds)) {

        if ($debug) array_push($Messages, 'Password changed successfully.');

        // Write new cookies for the password
        $onetimepad = OneTimePadCreate(strlen($cp_newpass));
        $_SESSION['onetimepad'] = $onetimepad;
        $key = OneTimePadEncrypt($cp_newpass, $onetimepad);
        setcookie('key', $key, 0, $base_uri);

	// If password was changed and reminder is used, set it back
	if ($mysql_password_force) {
            $quoteChar = $mysql_password_change_field_delimiter;
	    $update_string =  'UPDATE '. $mysql_table . ' SET ' . $mysql_password_change_field . '=' . $quoteChar . $mysql_password_change_no_value . $quoteChar;
    	    $update_string .= ' WHERE ' . $mysql_userid_field . '="' . $user . '"';
            if ($split_username_query)
            {
                $update_string .= ' AND ' . $split_username_domain_field . '="' . $domain. '"';
            }
	    $return=mysql_query($update_string,$ds);
	}

        // Automatically forward back to the options screen if correct
        if ($debug == 0) {


           // no longer using https:
           // (unless the flag is off, in which case we don't care - just
           // use what was already there)
           //   
           if (!$use_ssl_for_password_change)
               $location = 'http' . (isset($_SERVER["HTTPS"]) ? 's' : '');
           else
               $location = 'http';
               
           ereg("(^.*/).*", $_SERVER['REQUEST_URI'], $regs);
           $location .= '://' . $_SERVER['HTTP_HOST'];

           if (strstr($_SERVER['REQUEST_URI'], 'right_main.php')
            || strstr($_SERVER['REQUEST_URI'], 'webmail.php'))
              $location .= $regs[1] . 'right_main.php?optmode=submit&plugin_change_mysqlpass=1';
           else
              $location .= $regs[1] . '../../src/options.php?optmode=submit&plugin_change_mysqlpass=1';
        
        
           header("Location: $location");
           exit(0);

        }
        return $Messages;
    } else {
        array_push($Messages, _("Password change was not successful!"));
        return $Messages;
    }
    @mysql_close($ds);
}



?>
