<?php

/**
 * link.php
 *
 * Copyright (c) 2004 Simon Newell <simonnew@speedymail.org>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Allows an attachment of mime type application/document (.doc, .pdf, .sxw) to be
 * opened and its contents displayed on browser.
 *
 * Init the attachment html anchor link in the email message for the various document mime types
 * ./doc: doc_link
 * ./pdf: pdf_link
 * ./sxw: sxw_link
 *
 * Change the _("view") to the text that you want to be displayed beside each attachment 
 * with the corresponding mime type
 *
 * @package plugins
 * @subpackage attachment_doc
 */

function attachment_doc_doclink(&$Args) {
   sqgetGlobalVar('QUERY_STRING', $QUERY_STRING, SQ_SERVER);
   $Args[1]['attachment_doc']['href'] = SM_PATH . 'plugins/attachment_doc/includes/view_doc.php?'. $QUERY_STRING.
                                           '&amp;override_type0=text&amp;override_type1=html&amp;doctype=doc';
   $Args[1]['attachment_doc']['href'] = set_url_var($Args[1]['attachment_doc']['href'], 'ent_id',$Args[5]);
   $Args[1]['attachment_doc']['text'] = _("view");
   $Args[6] = $Args[1]['attachment_doc']['href'];
}

function attachment_doc_pdflink(&$Args) {
   sqgetGlobalVar('QUERY_STRING', $QUERY_STRING, SQ_SERVER);
   $Args[1]['attachment_doc']['href'] = SM_PATH . 'plugins/attachment_doc/includes/view_doc.php?'. $QUERY_STRING.
                                           '&amp;override_type0=text&amp;override_type1=html&amp;doctype=pdf';
   $Args[1]['attachment_doc']['href'] = set_url_var($Args[1]['attachment_doc']['href'], 'ent_id',$Args[5]);
   $Args[1]['attachment_doc']['text'] = _("view");
   $Args[6] = $Args[1]['attachment_doc']['href'];
}

function attachment_doc_sxwlink(&$Args) {
   sqgetGlobalVar('QUERY_STRING', $QUERY_STRING, SQ_SERVER);
   
   //check that the attachment is of .sxw format
   if(strcasecmp(substr($Args[7], strlen($Args[7])-4, 4), ".sxw") == 0) {
   		$Args[1]['attachment_doc']['href'] = SM_PATH . 'plugins/attachment_doc/includes/view_doc.php?'. $QUERY_STRING.
      					                                     '&amp;override_type0=text&amp;override_type1=html&amp;doctype=sxw';
   		$Args[1]['attachment_doc']['href'] = set_url_var($Args[1]['attachment_doc']['href'], 'ent_id',$Args[5]);
   		$Args[1]['attachment_doc']['text'] = _("view");
   		$Args[6] = $Args[1]['attachment_doc']['href'];
   }
}

?>