<?php

/**
 * cleanup.php
 *
 * Copyright (c) 2004 Simon Newell <simonnew@speedymail.org>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Allows an attachment of mime type application/document (.doc, .pdf, .sxw) to be
 * opened and its contents displayed on browser.
 *
 * Do some cleaning up such as removing all the graphics files created 
 * during conversion. Redirect to /src/read_body.php to display
 * message body.
 *
 * @package plugins
 * @subpackage attachment_doc
 */


/* Path for SquirrelMail required files. */
define('SM_PATH','../../../');

/* SquirrelMail required files. */
include_once(SM_PATH . 'include/validate.php');

sqgetGlobalVar('QUERY_STRING', $QUERY_STRING, SQ_SERVER);
sqgetGlobalVar('dirname', $dirname, SQ_GET);
sqgetGlobalVar('prefixname', $prefixname, SQ_GET);

/*
 * @Name: unlink_wc($dir,$pattern)
 * @Description: A unlink function that support wildcards ( * and ? )
 * (based on code taked from php.net manual comments)
 * @Author: Pablo Rosciani [ pabloATnkstudiosDOTnet ] [ http://pi.nks.com.ar ]
 * @Date: 15/10/03
 * @param string $dir      Directory to search files
 * @param string $pattern  Pattern to find.
 *
 */
function unlink_wc($dir, $pattern){
   if ($dh = opendir($dir)) {
      
       /* List and put into an array all files */
       while (false !== ($file = readdir($dh))){
           if ($file != "." && $file != "..") {
               $files[] = $file;
           }
       }
       closedir($dh);
      
       /* Split file name and extenssion */
       if(strpos($pattern,".")) {
           $baseexp=substr($pattern,0,strpos($pattern,"."));
           $typeexp=substr($pattern,strpos($pattern,".")+1,strlen($pattern));
       }else{
           $baseexp=$pattern;
           $typeexp="";
       }
      
       /* Escape all regexp Characters */
       $baseexp=preg_quote($baseexp);
       $typeexp=preg_quote($typeexp);
      
       /* Allow ? and * */
       $baseexp=str_replace(array("\*","\?"), array(".*","."), $baseexp);
       $typeexp=str_replace(array("\*","\?"), array(".*","."), $typeexp);
      
       /* Search for pattern match */
       $i=0;
       if ($files != NULL) { /* added check */
         foreach($files as $file) {
           $filename=basename($file);
           if(strpos($filename,".")) {
               $base=substr($filename,0,strpos($filename,"."));
               $type=substr($filename,strpos($filename,".")+1,strlen($filename));
           }else{
               $base=$filename;
               $type="";
           }
      
           if(preg_match("/^".$baseexp."$/i",$base) && preg_match("/^".$typeexp."$/i",$type))  {
               $matches[$i]=$file;
               $i++;
           }
         }
       }
      
       /* added check to original code to prevent error on trying to rm non-existing files */
       if ($i != 0) { 
        while(list($idx,$val) = each($matches)){
           if (substr($dir,-1) == "/"){
               unlink($dir.$val);
           }else{
               unlink($dir."/".$val);
           }
        }
       }
      
   }
} /* end of unlink_wc() */

//function to delete a directory
function delDir($dirName) {
   if(empty($dirName)) {
       return true;
   }
   if(file_exists($dirName)) {
       $dir = dir($dirName);
       while($file = $dir->read()) {
           if($file != '.' && $file != '..') {
               if(is_dir($dirName.'/'.$file)) {
                   delDir($dirName.'/'.$file);
               } else {
                   @unlink($dirName.'/'.$file) or die('File '.$dirName.'/'.$file.' couldn\'t be deleted!');
               }
           }
       }
       $dir->close();
       @rmdir($dirName) or die('Folder '.$dirName.' couldn\'t be deleted!');
   } else {
       return false;
   }
   return true;
}

/* remove all files created during conversion */
delDir("$dirname/$prefixname");
unlink_wc("$dirname", "$prefixname*.*");

/* redirect to /src/read_body.php to display message body */
$msg_redirect_url = SM_PATH . 'src/read_body.php?' . $QUERY_STRING;
$msg_redirect_url = set_url_var($msg_redirect_url, 'ent_id', 0);
header("Location: $msg_redirect_url");

?>
